import formCreate from '@form-create/element-ui';
import formCreateMobile from '@form-create/vant';
import {renderPreview} from './index';
import formulas from './formulas';
import behaviorAttr from './behavior';
import easySlotsAttr from './easySlots';
import useExtendApi from './extendApi';
import useExtendMessageApi from './extendMessageApi';
import useExtendPrintApi from './extendPrintApi';
import setting from '../extension/setting';


formCreateMobile.parser().preview = renderPreview;

Object.keys(formulas).forEach(k => {
    formCreateMobile.setFormula(k, formulas[k]);
});

const viewForm = formCreateMobile;

const designerForm = formCreateMobile.factory();

useExtendApi(viewForm);
useExtendMessageApi(viewForm);
useExtendPrintApi(viewForm);
useExtendApi(designerForm);
useExtendMessageApi(designerForm);
useExtendPrintApi(designerForm);
setting.extend.updateFormCreate(viewForm);
setting.extend.updateFormCreate(designerForm);

viewForm.register('behavior', behaviorAttr);
viewForm.register('easySlots', easySlotsAttr);
designerForm.register('easySlots', easySlotsAttr);

export default viewForm;

const elmFormCreate = formCreate;
useExtendApi(elmFormCreate);
useExtendMessageApi(elmFormCreate);

export {designerForm,  elmFormCreate};
