import {localeOptions, localeProps} from '../../utils';

const label = '标签';
const name = 'vanTag';

export default {
    menu: 'aide',
    icon: 'icon-tag',
    label,
    name,
    mask: true,
    inline: true,
    event: ['click', 'close'],
    rule({t}) {
        return {
            type: name,
            children: [t('com.vanTag.name')]
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {
                type: 'input',
                field: 'formCreateChild'
            }, {
                type: 'select',
                field: 'type',
                options: localeOptions(t, [{label: 'primary', value: 'primary'}, {
                    label: 'success',
                    value: 'success'
                }, {label: 'warning', value: 'warning'}, {label: 'danger', value: 'danger'}])
            }, {
                type: 'select',
                field: 'size',
                options: localeOptions(t, [{label: 'large', value: 'large'}, {
                    label: 'medium',
                    value: 'medium'
                }, {label: 'default', value: 'default'}])
            }, {
                type: 'ColorInput',
                field: 'color',
            }, {
                type: 'switch',
                field: 'plain',
            }, {
                type: 'switch',
                field: 'round',
            }, {
                type: 'ColorInput',
                field: 'textColor',
            }]);
    }
};
