import uniqueId from '@form-create/utils/lib/unique';
import {localeProps} from '../../utils';

const label = '开关';
const name = 'switch';

export default {
    menu: 'main',
    icon: 'icon-switch',
    label,
    name,
    input: true,
    event: ['change', 'click'],
    condition: function (rule) {
        return {
            type: 'switch',
            props: {
                activeValue: rule.props.activeValue,
                inactiveValue: rule.props.inactiveValue,
            }
        }
    },
    rule({t}) {
        return {
            type: name,
            field: uniqueId(),
            title: t('com.switch.name'),
            info: '',
            $required: false,
            props: {
                activeValue: true,
                inactiveValue: false,
            },
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {
                type: 'switch',
                field: 'disabled',
            },
            {
                type: 'ColorInput',
                field: 'activeColor',
            },
            {
                type: 'ColorInput',
                field: 'inactiveColor',
            },
            {
                type: 'ValueInput',
                field: 'activeValue',
            },
            {
                type: 'ValueInput',
                field: 'inactiveValue',
            }
        ]);
    }
};
