import {localeProps} from '../../utils';

const label = '图标';
const name = 'vanIcon';

export default {
    menu: 'aide',
    icon: 'icon-icon',
    label,
    name,
    inline: true,
    event: ['click'],
    rule() {
        return {
            type: name,
            props: {
                name: 'https://static.form-create.com/example.png',
                size: '1em',
            },
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {
                type: 'input',
                field: 'name',
            },
            {
                type: 'switch',
                field: 'dot',
            },
            {
                type: 'input',
                field: 'badge',
            },
            {
                type: 'ColorInput',
                field: 'color',
            },
            {
                type: 'SizeInput',
                field: 'size',
            }
        ]);
    }
};
