import {createApp} from 'vue';
import ELEMENT from 'element-plus';
import vant from 'vant';
import 'vant/lib/index.css';
import 'element-plus/dist/index.css';
import formCreate from '@form-create/element-ui';
import App from './App.vue';
import FcDesignerMobile from '../src/index';
import 'element-plus/theme-chalk/dark/css-vars.css'
// import install from "@form-create/element-ui/auto-import";
// import 'element-plus/es/components/message/style/css';

const app = createApp(App);

// formCreate.use(install);
app.use(vant);
app.use(ELEMENT);
app.use(formCreate);
app.use(FcDesignerMobile);
FcDesignerMobile.setFormula([
    {
        menu: 'math',
        name: 'test',
        info: '扩展自定义计算函数示例',
        example: 'test(val) == !!val',
        handle(val) {
            return !!val
        }
    }
])

FcDesignerMobile.setBehavior([
    {
        menu: 'other',
        name: 'test',
        label: '扩展自定义行为',
        info: '扩展自定义行为示例',
        rule() {
            return [
                {
                    type: 'input',
                    field: 'custom',
                    title: '自定义配置'
                }
            ]
        },
        handle(config) {
            console.log(config)
        }
    }
])

app.mount('#app')
