import {defineConfig} from 'vite'
import vue from '@vitejs/plugin-vue2'
import banner from 'vite-plugin-banner'
import cssInjectedByJsPlugin from 'vite-plugin-css-injected-by-js'
import {author, name, version} from './package.json'

const extnedsPlugins = [];

function getBanner(banner, pkg) {
    if (!banner || typeof banner === 'string') {
        return banner || '';
    }

    banner = {...pkg, ...(banner === true ? {} : banner)};

    const author = banner.author

    return {
        content: (
            '/*!\n' +
            ' * FormCreate商业版可视化移动端表单设计器-让表单设计更简单\n' +
            ` * ${banner.name} v${banner.version}\n` +
            ` * (c) ${author || ''}\n` +
            ' * license 仅限于被授权主体（个人、企业或组织）使用\n' +
            ' */'
        ),
        outDir: 'dist/mobile',
    };
}

const __banner__ = {
    author: `2018-${new Date().getFullYear()} ${author}  https://form-create.com/`,
    name,
    version
}

// https://vitejs.dev/config/
export default defineConfig({
    build: {
        lib: {
            entry: 'src/form/mobile.js',
            name: 'formCreateMobile',
            fileName: format => `form-create.vant.${format}.js`,
        },
        rollupOptions: {
            output: {
                exports: 'named',
                globals: {
                    vue: 'Vue',
                    vant: 'vant',
                    'element-ui': 'ElementUI',
                }
            },
            external: [
                'vue',
                'vant',
                'element-ui',
            ],

        },
        outDir: 'dist/mobile',
        brotliSize: true,
    },
    plugins: [vue(), banner(getBanner(__banner__)), cssInjectedByJsPlugin(), ...extnedsPlugins]
})
