import uniqueId from '@form-create/utils/lib/unique';
import {localeProps} from '../../utils';

const label = '时间';
const name = 'timePicker';

export default {
    menu: 'main',
    icon: 'icon-time',
    label,
    name,
    input: true,
    event: ['confirm', 'cancel', 'change'],
    sfc: {
        import: {
            name: 'fcTimePicker',
            path: '@form-create/vant/src/components/timePicker.jsx'
        }
    },
    rule({t}) {
        return {
            type: name,
            field: uniqueId(),
            title: t('com.timePicker.name'),
            info: '',
            $required: false,
            props: {},
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {
                type: 'switch',
                field: 'disabled'
            },
            {
                type: 'switch',
                field: 'clearable',
            },
            {
                type: 'input',
                field: 'title',
            }, {
                type: 'timePicker',
                field: 'minTime',
            }, {
                type: 'timePicker',
                field: 'maxTime',
            },
            {
                type: 'inputNumber',
                field: 'visibleOptionNum',
            },
            {
                type: 'input',
                field: 'placeholder',
            },
        ]);
    }
};
