import {localeOptions, localeProps} from '../../utils';
import {$set} from "@form-create/utils";

const label = '标签页';
const name = 'vanTabs';

export default {
    menu: 'layout',
    icon: 'icon-tab',
    label,
    name,
    mask: false,
    event: ['click', 'change', 'rendered', 'scroll'],
    children: 'vanTab',
    childrenLen: 2,
    subRender({t, h, subRule}) {
        return [
            {
                label: t('props.title'),
                vnode: h('el-input', {
                    props: {
                        size: 'small',
                    },
                    model: {
                        value: subRule.props.title,
                        callback: (v) => {
                            $set(subRule.props, 'title', v);
                        }
                    }
                })
            }
        ]
    },
    rule() {
        return {
            type: name,
            style: {width: '100%'},
            children: []
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {
                type: 'select',
                field: 'type',
                options: localeOptions(t, [
                    {label: 'card', value: 'card'},
                    {label: 'line', value: 'line'}
                ])
            },
            {
                type: 'ColorInput',
                field: 'color',
            },
            {
                type: 'ColorInput',
                field: 'background',
            },
            {
                type: 'switch',
                field: 'sticky',
            },
            {
                type: 'switch',
                field: 'swipeable',
            },
            {
                type: 'switch',
                field: 'scrollspy',
            },
            {
                type: 'ColorInput',
                field: 'titleActiveColor',
            },
            {
                type: 'ColorInput',
                field: 'titleInactiveColor',
            }
        ]);
    }
};
