import {$set} from "@form-create/utils";
import SizeInput from "../../components/style/SizeInput.vue";

const label = '盒子布局';
const name = 'fcFlex';

export default {
    icon: 'icon-flex',
    label,
    name,
    mask: false,
    children: 'fcCell',
    childrenLen: 2,
    subRender({t, h, subRule}) {
        return [
            {
                label: t('style.width'),
                vnode: h(SizeInput, {
                    props: {
                        size: 'small',
                    },
                    model: {
                        value: (subRule.style && subRule.style.width) || '',
                        callback: (v) => {
                            if (!subRule.style) {
                                subRule.style = {};
                                $set(subRule, 'style', {});
                            }
                            $set(subRule.style, 'width', v);
                        }
                    }
                })
            },
            {
                label: t('style.height'),
                vnode: h(SizeInput, {
                    props: {
                        size: 'small',
                    },
                    model: {
                        value: (subRule.style && subRule.style.height) || '',
                        callback: (v) => {
                            if (!subRule.style) {
                                subRule.style = {};
                                $set(subRule, 'style', {});
                            }
                            $set(subRule.style, 'height', v);
                        }
                    }
                })
            },
        ]
    },
    sfc(rule) {
        rule.type = 'vanRow';
    },
    rule() {
        return {
            type: 'fcRow',
            props: {},
            children: []
        };
    },
    props() {
        return [];
    }
};
