import {localeProps} from '../../utils';
import {$set} from "@form-create/utils";

const label = '折叠面板';
const name = 'vanCollapse';

export default {
    menu: 'layout',
    icon: 'icon-collapse',
    label,
    name,
    mask: false,
    event: ['change'],
    children: 'vanCollapseItem',
    subRender({t, h, subRule}) {
        return [
            {
                label: t('props.title'),
                vnode: h('el-input', {
                    props: {
                        size: 'small',
                    },
                    model: {
                        value: subRule.props.title,
                        callback: (v) => {
                            $set(subRule.props, 'title', v);
                        }
                    }
                })
            }
        ]
    },
    watch: {
        accordion({field, value, rule}) {
            if (field === 'accordion' && !value) {
                rule.props.value = [];
            }
        },
    },
    rule() {
        return {
            type: name,
            props: {
                value: []
            },
            sync: [{prop: 'value', event: 'input'}],
            style: {
                width: '100%',
            },
            children: []
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [{
            type: 'switch',
            field: 'accordion'
        }]);
    }
};
