import {localeProps} from '../../utils';
import {$set} from "@form-create/utils";

const name = 'vanCellGroup';

export default {
    menu: 'layout',
    icon: 'icon-descriptions',
    name,
    label: '单元格',
    children: 'vanCell',
    childrenLen: 2,
    mask: false,
    subRender({t, h, subRule}) {
        return [
            {
                label: t('props.title'),
                vnode: h('el-input', {
                    props: {
                        size: 'small',
                    },
                    model: {
                        value: subRule.props.title,
                        callback: (v) => {
                            $set(subRule.props, 'title', v);
                        }
                    }
                })
            },
            {
                label: t('props.content'),
                vnode: h('el-input', {
                    props: {
                        size: 'small',
                    },
                    model: {
                        value: subRule.props.value,
                        callback: (v) => {
                            $set(subRule.props, 'value', v);
                        }
                    }
                })
            }
        ]
    },
    rule({t}) {
        return {
            type: name,
            native: false,
            col: {show: true},
            wrap: {show: false},
            props: {
                title: t('com.' + name + '.name'),
            }
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {
                type: 'input',
                field: 'title',
            },
            {
                type: 'switch',
                field: 'inset',
            },
            {
                type: 'switch',
                field: 'border',
                value: true,
            }
        ]);
    }
};
