import formCreate from "@form-create/element-ui";
import ELEMENT from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import vant from 'vant';
import 'vant/lib/index.css';
import Vue from "vue";
import FcDesignerMobile from "../src/index.js";
import App from "./App.vue";

Vue.use(vant);
Vue.use(ELEMENT);
Vue.use(formCreate);
Vue.use(FcDesignerMobile);

FcDesignerMobile.setFormula([
    {
        menu: 'math',
        name: 'test',
        info: '扩展自定义计算函数示例',
        example: 'test(val) == !!val',
        handle(val) {
            return !!val
        }
    }
])

FcDesignerMobile.setBehavior([
    {
        menu: 'other',
        name: 'test',
        label: '扩展自定义行为',
        info: '扩展自定义行为示例',
        rule() {
            return [
                {
                    type: 'input',
                    field: 'custom',
                    title: '自定义配置'
                }
            ]
        },
        handle(config) {
            console.log(config)
        }
    }
])

Vue.config.productionTip = false;

new Vue({
    render: (h) => h(App),
}).$mount("#app");
