/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.services.impls;

import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncCommand;
import com.bcxin.runtime.domain.syncs.commands.CreateFtpDataSyncCommand;
import com.bcxin.runtime.domain.syncs.commands.CreateSyncViaFtpCallbackCommand;
import com.bcxin.runtime.domain.syncs.commands.results.CreateDataSyncCommandResult;
import com.bcxin.runtime.domain.syncs.commands.results.CreateFtpDataSyncCommandResult;
import com.bcxin.runtime.domain.syncs.commands.results.CreateSyncViaFtpCallbackCommandResult;
import com.bcxin.runtime.domain.syncs.dtos.FtpConfigInfoDto;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.runtime.domain.syncs.services.DataSyncService;
import com.bcxin.runtime.domain.syncs.services.SyncViaFtpService;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import java.util.HashMap;

public class SyncViaFtpServiceImpl
implements SyncViaFtpService {
    private final DataSyncService dataSyncService;
    private final JsonProvider jsonProvider;
    private final DataSyncQueueRepository dataSyncQueueRepository;

    public SyncViaFtpServiceImpl(DataSyncService dataSyncService, JsonProvider jsonProvider, DataSyncQueueRepository dataSyncQueueRepository) {
        this.dataSyncService = dataSyncService;
        this.jsonProvider = jsonProvider;
        this.dataSyncQueueRepository = dataSyncQueueRepository;
    }

    @Override
    public CreateFtpDataSyncCommandResult create(CreateFtpDataSyncCommand command, FtpConfigInfoDto ftpConfigInfoDto) {
        CreateDataSyncCommandResult result = this.dataSyncService.create(CreateDataSyncCommand.create(command.getDataSets(), command.getFilePaths(), command.getUrlFilePathMappings()), ftpConfigInfoDto);
        return CreateFtpDataSyncCommandResult.create(result.getDataSetResults(), result.isSavedFileQueued());
    }

    @Override
    public CreateSyncViaFtpCallbackCommandResult create(CreateSyncViaFtpCallbackCommand command) {
        DataSyncQueueEntity dataSyncQueueEntity = this.dataSyncQueueRepository.getByThirdPartId(command.getMsgId());
        if (dataSyncQueueEntity == null) {
            throw new SaasNofoundException(String.format("\u627e\u4e0d\u5230\u8be5msg(%s)\u4fe1\u606f", command.getMsgId()));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("msgId", command.getMsgId());
        result.put("result", command.getResult());
        result.put("execStatus", command.getExecStatus());
        dataSyncQueueEntity.assignCallback(command.getExecStatus(), this.jsonProvider.getJson(result));
        this.dataSyncQueueRepository.save(dataSyncQueueEntity);
        return CreateSyncViaFtpCallbackCommandResult.create(dataSyncQueueEntity.getId());
    }
}

