/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.services.impls;

import com.bcxin.runtime.domain.snapshoots.JdbcMapSnapshot;
import com.bcxin.runtime.domain.snapshoots.TableMapSnapshot;
import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncCommand;
import com.bcxin.runtime.domain.syncs.commands.CreateSyncFileCommand;
import com.bcxin.runtime.domain.syncs.commands.results.CreateDataSyncCommandResult;
import com.bcxin.runtime.domain.syncs.components.DbSyncExecutor;
import com.bcxin.runtime.domain.syncs.dtos.FileItemRequestDto;
import com.bcxin.runtime.domain.syncs.dtos.FtpConfigInfoDto;
import com.bcxin.runtime.domain.syncs.entities.DataSyncLogEntity;
import com.bcxin.runtime.domain.syncs.entities.DataSyncMapEntity;
import com.bcxin.runtime.domain.syncs.entities.FileSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.ProcessedStatus;
import com.bcxin.runtime.domain.syncs.ftp.FtpUploadTask;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncLogRepository;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncMapRepository;
import com.bcxin.runtime.domain.syncs.repositories.FileSyncQueueRepository;
import com.bcxin.runtime.domain.syncs.services.DataSyncService;
import com.bcxin.saas.core.AppConfigProperty;
import com.bcxin.saas.core.components.HttpRequestProvider;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSyncServiceImpl
implements DataSyncService {
    private static Logger logger = LoggerFactory.getLogger(DataSyncServiceImpl.class);
    private static ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(15);
    private final DataSyncMapRepository dataMapSyncRepository;
    private final DataSyncLogRepository dataSyncLogRepository;
    private final JsonProvider jsonProvider;
    private final DbSyncExecutor dbSyncExecutor;
    private final HttpRequestProvider httpRequestProvider;
    private final AppConfigProperty appConfigProperty;
    private final FileSyncQueueRepository fileSyncQueueRepository;
    private static Map<String, Collection<TableMapSnapshot.Column>> tableMapSnapshotColumns = new ConcurrentHashMap<String, Collection<TableMapSnapshot.Column>>();

    public DataSyncServiceImpl(DataSyncMapRepository dataMapSyncRepository, DataSyncLogRepository dataSyncLogRepository, JsonProvider jsonProvider, DbSyncExecutor dbSyncExecutor, HttpRequestProvider httpRequestProvider, AppConfigProperty appConfigProperty, FileSyncQueueRepository fileSyncQueueRepository) {
        this.dataMapSyncRepository = dataMapSyncRepository;
        this.dataSyncLogRepository = dataSyncLogRepository;
        this.jsonProvider = jsonProvider;
        this.dbSyncExecutor = dbSyncExecutor;
        this.httpRequestProvider = httpRequestProvider;
        this.appConfigProperty = appConfigProperty;
        this.fileSyncQueueRepository = fileSyncQueueRepository;
    }

    @Override
    public CreateDataSyncCommandResult create(CreateDataSyncCommand command, FtpConfigInfoDto ftpConfigInfoDto) {
        if (command.getDataSets() == null || command.getDataSets().size() == 0) {
            throw new SaasBadException("DataSets\u6570\u636e\u96c6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.isEmpty((CharSequence)command.getFilePaths()) && command.getUrlFilePathMappings() == null) {
            throw new SaasBadException(String.format("\u7cfb\u7edf\u7248\u672c\u4e0d\u4e00\u81f4(filePath=%s;urlFilePathMappings=NULL), \u5bfc\u81f4\u6587\u4ef6\u65e0\u6cd5\u6b63\u5e38\u4e0b\u8f7d\u5230\u76ee\u6807\u7cfb\u7edf,\u4f46\u662f\u6570\u636e", command.getFilePaths()));
        }
        Collection mapKeys = command.getDataSets().stream().map(ii -> ii.getMapKey()).collect(Collectors.toList());
        Collection<DataSyncMapEntity> dataMapSyncEntities = this.dataMapSyncRepository.getAllByMapKeys(mapKeys);
        ArrayList<DataSyncLogEntity> dataSyncLogEntities = new ArrayList<DataSyncLogEntity>();
        AtomicReference randomSyncMapEntity = new AtomicReference();
        command.getDataSets().forEach(ds -> {
            ProcessedStatus status = ProcessedStatus.Done;
            String result = "\u5b8c\u6210";
            Collection<DataSyncMapEntity> dataSyncMapEntities = dataMapSyncEntities.stream().filter(ii -> ii.getMapKey().equals(ds.getMapKey())).collect(Collectors.toList());
            if (dataSyncMapEntities.size() == 0 && (dataSyncMapEntities = this.getRegexDataSyncMapEntities((CreateDataSyncCommand.DataSet)ds)).size() == 0) {
                throw new SaasNofoundException(String.format("\u627e\u4e0d\u5230%s\u6570\u636e\u6620\u5c04\u914d\u7f6e, \u65e0\u6cd5\u6267\u884c\u540c\u6b65\u64cd\u4f5c", ds.getMapKey()));
            }
            for (DataSyncMapEntity dataMapSync : dataSyncMapEntities) {
                try {
                    dataMapSync = this.doJdbcProcess(dataMapSync, (CreateDataSyncCommand.DataSet)ds);
                    status = ProcessedStatus.Done;
                }
                catch (Exception ex) {
                    status = ProcessedStatus.Error;
                    result = ExceptionUtils.getStackMessage((Throwable)ex);
                    throw ex;
                }
                finally {
                    randomSyncMapEntity.set(dataMapSync);
                    String jsonData = this.jsonProvider.getJson((Object)command.getFilePaths());
                    if (StringUtils.isEmpty((CharSequence)jsonData)) {
                        jsonData = ds.getId();
                    }
                    dataSyncLogEntities.add(DataSyncLogEntity.create(dataMapSync, ds.getId(), jsonData, status, result));
                }
            }
        });
        if (randomSyncMapEntity == null || randomSyncMapEntity.get() == null) {
            throw new SaasBadException("randomSyncMapEntity\u65e0\u6548!");
        }
        boolean savedFileQueued = this.saveSyncLogAndFiles(command, dataSyncLogEntities, ftpConfigInfoDto);
        Collection results = dataSyncLogEntities.stream().map(ii -> CreateDataSyncCommandResult.DataSetResult.create(ii.getSyncQueueId(), ii.getStatus() == ProcessedStatus.Done, ii.getResult())).collect(Collectors.toList());
        return CreateDataSyncCommandResult.create(results, savedFileQueued);
    }

    @Override
    public CreateSyncFileCommand.CreateSyncFileCommandResult create(CreateSyncFileCommand command) {
        Collection<FileItemRequestDto> fileItemRequestDtos = command.getFileItems();
        ArrayList<CreateSyncFileCommand.FileItemResponse> fileItemResponses = new ArrayList<CreateSyncFileCommand.FileItemResponse>();
        fileItemRequestDtos.forEach(ii -> {
            CreateSyncFileCommand.FileItemResponse fileItemResponse = null;
            try {
                String rootPath = this.appConfigProperty.getRootPath();
                if (rootPath != null && rootPath.endsWith("/")) {
                    rootPath = rootPath.substring(0, rootPath.length() - 1);
                }
                String targetPath = String.format("%s/%s", rootPath, ii.getTargetPath());
                this.httpRequestProvider.download(ii.getSourceUrl(), targetPath);
                fileItemResponse = CreateSyncFileCommand.FileItemResponse.create(ii, true, "targetPath");
            }
            catch (Exception ex) {
                fileItemResponse = CreateSyncFileCommand.FileItemResponse.create(ii, false, ex.toString());
            }
            finally {
                fileItemResponses.add(fileItemResponse);
            }
        });
        return CreateSyncFileCommand.CreateSyncFileCommandResult.create(command.getId(), fileItemResponses);
    }

    private DataSyncMapEntity doJdbcProcess(DataSyncMapEntity dataSyncMapEntity, CreateDataSyncCommand.DataSet ds) {
        JdbcMapSnapshot snapshot = this.calculateJdbcMapSnapshot(dataSyncMapEntity, ds);
        this.dbSyncExecutor.execute(snapshot, ds.getRows(), ds.getDeletedIds());
        return dataSyncMapEntity;
    }

    private Collection<DataSyncMapEntity> getRegexDataSyncMapEntities(CreateDataSyncCommand.DataSet ds) {
        Collection<DataSyncMapEntity> dataSyncMapEntities = this.dataMapSyncRepository.getAllRegexByMapKeys();
        return dataSyncMapEntities.stream().filter(ii -> ds.getAutoMapTableName(ii.getMapKey()) != null).collect(Collectors.toList());
    }

    private JdbcMapSnapshot calculateJdbcMapSnapshot(DataSyncMapEntity dataSyncMapEntity, CreateDataSyncCommand.DataSet ds) {
        JdbcMapSnapshot snapshot = (JdbcMapSnapshot)this.jsonProvider.getData(dataSyncMapEntity.getTargetConfig(), JdbcMapSnapshot.class);
        if (snapshot.getTableMap().isAutoMap()) {
            Collection<TableMapSnapshot.Column> mapColumns;
            if (StringUtils.isEmpty((CharSequence)snapshot.getTableMap().getTableName()) || "*".equalsIgnoreCase(snapshot.getTableMap().getTableName())) {
                snapshot.getTableMap().setTableName(ds.getAutoMapTableName(dataSyncMapEntity.getMapKey()));
            }
            if ((mapColumns = tableMapSnapshotColumns.get(snapshot.getTableMap().getTableName())) == null) {
                mapColumns = new ArrayList<TableMapSnapshot.Column>();
                DataSource dataSource = this.dbSyncExecutor.getDataSource(snapshot.getJdbcConnection());
                try (Connection connection = dataSource.getConnection();){
                    String pingSql = String.format("select * from %s where 1<>1 limit 1", snapshot.getTableMap().getTableName());
                    try (Statement pingStatement = connection.createStatement();){
                        ResultSet resultSet = pingStatement.executeQuery(pingSql);
                        for (int columnIndex = 0; columnIndex < resultSet.getMetaData().getColumnCount(); ++columnIndex) {
                            TableMapSnapshot.Column tableColumn = TableMapSnapshot.Column.add(resultSet.getMetaData().getColumnName(columnIndex + 1), null);
                            mapColumns.add(tableColumn);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new SaasBadException(String.format("[%s]: \u627e\u4e0d\u5230\u8868(%s)\u5143\u6570\u636e\u4fe1\u606f", dataSyncMapEntity.getId(), snapshot.getTableMap().getTableName()), ex);
                }
                tableMapSnapshotColumns.put(snapshot.getTableMap().getTableName(), mapColumns);
            }
            for (TableMapSnapshot.Column selColumn : mapColumns) {
                Optional<TableMapSnapshot.Column> columnOptional = snapshot.getTableMap().getColumns().stream().filter(ix -> ix.getFieldName().equalsIgnoreCase(selColumn.getFieldName())).findFirst();
                if (!columnOptional.isPresent()) continue;
                selColumn.setDefaultValue(columnOptional.get().getDefaultValue());
                selColumn.setFixedValue(columnOptional.get().getFixedValue());
                selColumn.setOnlyForNew(columnOptional.get().isOnlyForNew());
            }
            snapshot.getTableMap().setColumns(mapColumns);
        }
        return snapshot;
    }

    private boolean saveSyncLogAndFiles(CreateDataSyncCommand command, Collection<DataSyncLogEntity> dataSyncLogEntities, FtpConfigInfoDto ftpConfigInfoDto) {
        boolean savedFileQueued = false;
        StringBuilder filePathTracking = new StringBuilder(String.format("\u5f85\u5904\u7406\u6587\u4ef6\u5217\u8868\u662f\u5426\u4e3a\u7a7a=%s;", StringUtils.isEmpty((CharSequence)command.getFilePaths())));
        try {
            String firstSynclogId = "EMPTY";
            DataSyncLogEntity syncLogEntity = null;
            if (!dataSyncLogEntities.isEmpty()) {
                syncLogEntity = dataSyncLogEntities.stream().findFirst().get();
                firstSynclogId = syncLogEntity.getId();
            }
            filePathTracking.append(String.format("\u8be6\u7ec6\u53c2\u6570=%s;", this.jsonProvider.getJson((Object)command)));
            if (!StringUtils.isEmpty((CharSequence)command.getFilePaths())) {
                Collection paths = Arrays.stream(command.getFilePaths().split(",")).filter(ii -> !StringUtils.isEmpty((CharSequence)ii)).distinct().collect(Collectors.toList());
                filePathTracking.append(String.format("\u603b\u5171%s\u4e2a\u6587\u4ef6; urlMapping=%s;", paths.size(), command.getUrlFilePathMappings().size()));
                Collection dataSetFilesPathOptions = command.getDataSets().stream().flatMap(ix -> ix.getRows().stream()).flatMap(ix -> ix.getFieldValues().stream()).filter(ix -> ix.isValidFile()).flatMap(ix -> ix.getPathOptions().stream()).filter(ix -> !StringUtils.isEmpty((CharSequence)ix.getOriginalPath())).collect(Collectors.toList());
                filePathTracking.append(String.format("dataSetFilesPathOptions=%s;", this.jsonProvider.getJson((Object)dataSetFilesPathOptions)));
                filePathTracking.append("[");
                String finalFirstSynclogId = firstSynclogId;
                Collection fileSyncQueueEntities = paths.stream().flatMap(downloadUrl -> {
                    try {
                        String finalOriginalDownloadUrl = command.getOriginalDownloadUrl((String)downloadUrl);
                        Collection targetPaths = dataSetFilesPathOptions.stream().filter(ix -> !StringUtils.isEmpty((CharSequence)finalOriginalDownloadUrl) && ix.getOriginalPath().equalsIgnoreCase(finalOriginalDownloadUrl)).map(ix -> ix.getPath()).distinct().collect(Collectors.toList());
                        filePathTracking.append(String.format("\u6620\u5c04\u6587\u4ef6key=%s;\u5339\u914d\u7ed3\u679c=%s;", finalOriginalDownloadUrl, targetPaths.size()));
                        Collection queues = targetPaths.stream().map(tp -> FileSyncQueueEntity.create(downloadUrl, tp, command.getDataSetId(), finalFirstSynclogId)).collect(Collectors.toList());
                        return queues.stream();
                    }
                    catch (Exception ex) {
                        return Stream.empty();
                    }
                }).collect(Collectors.toList());
                filePathTracking.append("]");
                filePathTracking.append(String.format("\u5f85\u63d0\u4ea4\u7684fileSyncQueueEntities\u5bf9\u8c61=%s\u4e2a;", fileSyncQueueEntities.size()));
                if (!fileSyncQueueEntities.isEmpty()) {
                    if (ftpConfigInfoDto != null && ftpConfigInfoDto.getUseFtp().booleanValue()) {
                        ArrayList results = new ArrayList();
                        for (FileSyncQueueEntity fileSyncQueueEntity : fileSyncQueueEntities) {
                            FtpUploadTask ftpUploadTask = new FtpUploadTask(fileSyncQueueEntity, ftpConfigInfoDto);
                            Future submit = newFixedThreadPool.submit(ftpUploadTask);
                            results.add(submit);
                        }
                        fileSyncQueueEntities.clear();
                        for (Future future : results) {
                            try {
                                FileSyncQueueEntity resultFileSyncQueueEntity = (FileSyncQueueEntity)future.get(2L, TimeUnit.MINUTES);
                                fileSyncQueueEntities.add(resultFileSyncQueueEntity);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    filePathTracking.append("\u51c6\u5907\u4fdd\u5b58\u6587\u4ef6\u961f\u5217\u4fe1\u606f;");
                    this.fileSyncQueueRepository.saveAll(fileSyncQueueEntities);
                    filePathTracking.append("\u6267\u884c\u5b8c\u6587\u4ef6\u961f\u5217\u7684\u4fdd\u5b58;");
                    savedFileQueued = true;
                }
            }
            try {
                String data = String.format("\u9644\u4ef6\u4fe1\u606f:%s", filePathTracking);
                dataSyncLogEntities.add(DataSyncLogEntity.create(syncLogEntity.getDataMapSync(), syncLogEntity.getSyncQueueId(), "FileSyncQueueEntity.Tracking", ProcessedStatus.Done, data));
            }
            catch (Exception ex) {
                filePathTracking.append(String.format("\u521b\u5efa\u9644\u52a0\u4fe1\u606f\u5f02\u5e38:%s;", ex.toString()));
            }
            filePathTracking.append(String.format("\u6267\u884cdataSyncLogEntities\u7684\u4fdd\u5b58\u64cd\u4f5c=%s;", dataSyncLogEntities.size()));
            if (!dataSyncLogEntities.isEmpty()) {
                this.dataSyncLogRepository.saveAll(dataSyncLogEntities);
                filePathTracking.append("dataSyncLogEntities\u4fdd\u5b58\u6210\u529f;");
            }
            return savedFileQueued;
        }
        catch (Exception ex) {
            filePathTracking.append(String.format("\u6267\u884csaveSyncLogAndFiles\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38: %s", ExceptionUtils.getStackMessage((Throwable)ex)));
            logger.error("\u6267\u884csaveSyncLogAndFiles\u5b8c\u6bd5:{}", (Object)filePathTracking);
            throw ex;
        }
    }
}

