/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.syncs.ftp;

import cn.hutool.core.util.StrUtil;
import com.bcxin.runtime.domain.syncs.dtos.FtpConfigInfoDto;
import com.bcxin.runtime.domain.syncs.entities.FileSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.UploadStatus;
import com.bcxin.runtime.domain.syncs.ftp.FtpUtils;
import java.util.concurrent.Callable;

public class FtpUploadTask
implements Callable {
    private FileSyncQueueEntity fileSyncQueueEntity;
    private FtpConfigInfoDto ftpConfigInfoDto;

    public FtpUploadTask(FileSyncQueueEntity fileSyncQueueEntit, FtpConfigInfoDto ftpConfigInfoDto) {
        this.fileSyncQueueEntity = fileSyncQueueEntit;
        this.ftpConfigInfoDto = ftpConfigInfoDto;
    }

    public FileSyncQueueEntity call() throws Exception {
        try {
            String localPath = this.fileSyncQueueEntity.getDownloadUrl();
            String remotePath = this.fileSyncQueueEntity.getPath();
            remotePath = StrUtil.isEmpty((CharSequence)this.ftpConfigInfoDto.getFilePath()) ? remotePath : this.ftpConfigInfoDto.getFilePath() + remotePath;
            UploadStatus uploadStatus = FtpUtils.bcxUploadFile(this.ftpConfigInfoDto.getHost(), this.ftpConfigInfoDto.getUserName(), this.ftpConfigInfoDto.getPassword(), this.ftpConfigInfoDto.getPort(), remotePath, localPath.substring(localPath.indexOf("path=")).replace("path=", ""));
            switch (uploadStatus) {
                case Create_Directory_Fail: {
                    this.fileSyncQueueEntity.makeStatus(false, "\u8fdc\u7a0b\u670d\u52a1\u5668\u76f8\u5e94\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
                    break;
                }
                case Create_Directory_Success: {
                    this.fileSyncQueueEntity.makeStatus(false, "\u8fdc\u7a0b\u670d\u52a1\u5668\u521b\u5efa\u76ee\u5f55\u6210\u529f");
                    break;
                }
                case Upload_New_File_Success: {
                    this.fileSyncQueueEntity.makeStatus(true, "\u4e0a\u4f20\u65b0\u6587\u4ef6\u6210\u529f");
                    break;
                }
                case Upload_New_File_Failed: {
                    this.fileSyncQueueEntity.makeStatus(false, "\u4e0a\u4f20\u65b0\u6587\u4ef6\u5931\u8d25");
                    break;
                }
                case File_Exits: {
                    this.fileSyncQueueEntity.makeStatus(true, "\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
                    break;
                }
                case File_Not_Exits: {
                    this.fileSyncQueueEntity.makeStatus(false, "\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
                    break;
                }
                case Remote_Bigger_Local: {
                    this.fileSyncQueueEntity.makeStatus(true, "\u8fdc\u7a0b\u6587\u4ef6\u5927\u4e8e\u672c\u5730\u6587\u4ef6");
                    break;
                }
                case Upload_From_Break_Success: {
                    this.fileSyncQueueEntity.makeStatus(true, "\u65ad\u70b9\u7eed\u4f20\u6210\u529f");
                    break;
                }
                case Upload_From_Break_Failed: {
                    this.fileSyncQueueEntity.makeStatus(false, "\u65ad\u70b9\u7eed\u4f20\u5931\u8d25");
                    break;
                }
                case Delete_Remote_Faild: {
                    this.fileSyncQueueEntity.makeStatus(false, "\u5220\u9664\u8fdc\u7a0b\u6587\u4ef6\u5931\u8d25");
                    break;
                }
                default: {
                    this.fileSyncQueueEntity.makeStatus(false, "");
                    break;
                }
            }
        }
        catch (Exception e) {
            StackTraceElement stackTrace = e.getStackTrace()[0];
            String message = "\uff0c\u7c7b\u540d\uff1a" + stackTrace.getClassName() + "\uff0c\u65b9\u6cd5\u540d\uff1a" + stackTrace.getMethodName() + "\uff0c\u62a5\u9519\u884c\u53f7\uff1a" + stackTrace.getLineNumber();
            this.fileSyncQueueEntity.makeStatus(false, "\u5f02\u5e38\uff1a" + e.getMessage() + message);
        }
        return this.fileSyncQueueEntity;
    }
}

