/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.metas.services.impls;

import com.bcxin.runtime.domain.metas.commands.RefreshAppCommand;
import com.bcxin.runtime.domain.metas.entities.ApplicationMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.ApplicationMetaRepository;
import com.bcxin.runtime.domain.metas.services.ApplicationMetaService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class ApplicationMetaServiceImpl
implements ApplicationMetaService {
    private final ApplicationMetaRepository applicationMetaRepository;

    public ApplicationMetaServiceImpl(ApplicationMetaRepository applicationMetaRepository) {
        this.applicationMetaRepository = applicationMetaRepository;
    }

    @Override
    public void refresh(RefreshAppCommand command) {
        List<ApplicationMetaEntity> applicationMetaEntities = this.applicationMetaRepository.findAll();
        for (ApplicationMetaEntity applicationMetaEntity : applicationMetaEntities) {
            Optional<RefreshAppCommand.Application> appOption = command.getApplications().stream().filter(ca -> ca.getId().equals(applicationMetaEntity.getAppId())).findFirst();
            if (!appOption.isPresent()) continue;
            RefreshAppCommand.Application app = appOption.get();
            this.copyValue2DestDataSources(app.getDataSources(), applicationMetaEntity);
            this.copyValue2DestForms(app.getForms(), applicationMetaEntity);
        }
        for (RefreshAppCommand.Application application : command.getApplications()) {
            Optional<ApplicationMetaEntity> metaEntityOptional = applicationMetaEntities.stream().filter(ap -> ap.getAppId().equals(application.getId())).findFirst();
            ApplicationMetaEntity metaEntity = null;
            if (metaEntityOptional.isPresent()) {
                metaEntity = metaEntityOptional.get();
            } else {
                metaEntity = ApplicationMetaEntity.create(UUID.randomUUID().toString(), application.getId(), application.getName(), application.isOnline(), application.getNote());
                applicationMetaEntities.add(metaEntity);
            }
            this.copyValue2DestDataSources(application.getDataSources(), metaEntity);
            this.copyValue2DestForms(application.getForms(), metaEntity);
        }
        this.applicationMetaRepository.saveAll(applicationMetaEntities);
    }

    private void copyValue2DestDataSources(Collection<RefreshAppCommand.DataSource> dataSources, ApplicationMetaEntity applicationMetaEntity) {
        for (RefreshAppCommand.DataSource ds : dataSources) {
            applicationMetaEntity.addDataSourceMeta(ds.getId(), ds.getName(), ds.getEnumDriveType(), ds.getEnumDbType(), ds.getConfig(), "", ds.isSelected());
        }
    }

    private void copyValue2DestForms(Collection<RefreshAppCommand.Form> forms, ApplicationMetaEntity applicationMetaEntity) {
        for (RefreshAppCommand.Form fm : forms) {
            applicationMetaEntity.addFormMeta(fm.getId(), fm.getName(), fm.getTableName(), fm.getFormType());
        }
    }
}

