/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.imports.entities;

import com.bcxin.runtime.domain.imports.entities.enums.ProcessedStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="import_data_queues")
public class DataQueueEntity
extends EntityBase<String>
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(length=100, nullable=false)
    private String referenceId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date businessDateTime;
    @Column(length=8000)
    private String body;
    @Enumerated
    private ProcessedStatus status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date createdTime;
    @Column(length=8000)
    private String result;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastProcessedTime;

    public void changeStatus(ProcessedStatus status, String message) {
        this.setStatus(status);
        this.setResult(this.result);
        this.setLastProcessedTime(new Date());
    }

    protected DataQueueEntity() {
    }

    private DataQueueEntity(String referenceId, Date businessDateTime, String body) {
        this.setId(UUID.randomUUID().toString());
        this.setBody(body);
        this.setCreatedTime(new Date());
        this.setBusinessDateTime(businessDateTime);
        this.setReferenceId(referenceId);
        this.setStatus(ProcessedStatus.Initialize);
    }

    public static DataQueueEntity create(String referenceId, Date businessDateTime, String body) {
        return new DataQueueEntity(referenceId, businessDateTime, body);
    }

    public String getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public Date getBusinessDateTime() {
        return this.businessDateTime;
    }

    public String getBody() {
        return this.body;
    }

    public ProcessedStatus getStatus() {
        return this.status;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public String getResult() {
        return this.result;
    }

    public Date getLastProcessedTime() {
        return this.lastProcessedTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    protected void setBusinessDateTime(Date businessDateTime) {
        this.businessDateTime = businessDateTime;
    }

    protected void setBody(String body) {
        this.body = body;
    }

    protected void setStatus(ProcessedStatus status) {
        this.status = status;
    }

    protected void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    protected void setResult(String result) {
        this.result = result;
    }

    protected void setLastProcessedTime(Date lastProcessedTime) {
        this.lastProcessedTime = lastProcessedTime;
    }
}

