/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.domain.constants;

import com.alibaba.fastjson.JSON;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.google.common.io.Files;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldNames {
    private static final Logger log = LoggerFactory.getLogger(FieldNames.class);
    private static final Logger logger = LoggerFactory.getLogger(FieldNames.class);
    public static final Collection<String> ATTACHMENT_FILE_NAMES = new ArrayList<String>();

    public static boolean isFile(String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            return false;
        }
        return ATTACHMENT_FILE_NAMES.stream().anyMatch(ii -> fieldName.toLowerCase(Locale.ROOT).contains((CharSequence)ii));
    }

    public static boolean isFileIgnoreCase(String lowerFieldName) {
        if (StringUtils.isEmpty((CharSequence)lowerFieldName)) {
            return false;
        }
        return ATTACHMENT_FILE_NAMES.stream().anyMatch(ii -> lowerFieldName.contains((CharSequence)ii));
    }

    public static String formattedFileValue(String sitePrefix, String dId, String rowId, String value) {
        try {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return value;
            }
            if (!value.contains("[")) {
                String newValue = FieldNames.getPathString(value);
                return newValue;
            }
            List pathOptions = JSON.parseArray((String)value, PathOption.class);
            for (int index = 0; index < pathOptions.size(); ++index) {
                PathOption pathOption = (PathOption)pathOptions.get(index);
                String originalPath = pathOption.getPath();
                pathOption.setOriginalPath(originalPath);
                String fileName = null;
                if (!StringUtils.isEmpty((CharSequence)originalPath) && !"null".equalsIgnoreCase(originalPath)) {
                    String newPathValue = originalPath;
                    fileName = StringUtils.isNotEmpty((CharSequence)pathOption.getName()) ? pathOption.getName() : String.format("%s.%s", Files.getNameWithoutExtension((String)originalPath), Files.getFileExtension((String)originalPath));
                    if (originalPath.toLowerCase(Locale.ROOT).startsWith("http")) {
                        if (originalPath.contains("/uploads")) {
                            newPathValue = originalPath.substring(originalPath.indexOf("/uploads"), originalPath.length());
                        } else if (originalPath.contains("/upload")) {
                            newPathValue = originalPath.substring(originalPath.indexOf("/upload"), originalPath.length()).replaceFirst("/upload", "/uploads");
                        } else {
                            String temPath = originalPath.replace("http://", "").replace("https://", "");
                            newPathValue = String.format("/uploads%s", temPath.substring(temPath.indexOf("/")));
                        }
                        if (newPathValue.contains("%2F")) {
                            newPathValue = newPathValue.replace("%2F", "/");
                        }
                    }
                    int indexSeparator = originalPath.lastIndexOf("/");
                    String fileName2 = originalPath.substring(indexSeparator + 1);
                    log.info("fileName2={}", (Object)fileName2);
                    String urlPathX = originalPath.substring(0, indexSeparator + 1);
                    log.info("urlPathX={}", (Object)urlPathX);
                    originalPath = String.format("%s/v2/sync/file/download?f=%s", sitePrefix, urlPathX + URLEncoder.encode(fileName2, "UTF-8"));
                    pathOption.setOriginalPath(originalPath);
                    pathOption.setPath(newPathValue);
                }
                if (StringUtils.isEmpty(fileName)) {
                    fileName = UUID.randomUUID().toString();
                }
                if (StringUtils.isEmpty((CharSequence)pathOption.getUid())) {
                    pathOption.setUid(rowId.concat(fileName));
                }
                pathOption.setName(fileName);
            }
            return JSON.toJSONString((Object)pathOptions);
        }
        catch (Exception ex) {
            logger.error(String.format("\u683c\u5f0f\u5316\u6587\u4ef6(%s)\u4fe1\u606f\u5f02\u5e38:%s", value, ExceptionUtils.getStackMessage((Throwable)ex)));
            return value;
        }
    }

    private static String getPathString(String value) {
        String newValue = value;
        if (value.toLowerCase(Locale.ROOT).startsWith("http")) {
            if (value.contains("/uploads")) {
                newValue = value.substring(value.indexOf("/uploads"), value.length());
            } else if (value.contains("/upload")) {
                newValue = value.substring(value.indexOf("/upload"), value.length()).replaceFirst("/upload", "/uploads");
            } else {
                String temPath = value.replace("http://", "").replace("https://", "");
                newValue = String.format("/uploads%s", temPath.substring(temPath.indexOf("/")));
            }
            if (newValue.contains("%2F")) {
                newValue = newValue.replace("%2F", "/");
            }
        }
        return newValue;
    }

    public static Collection<String> extractPathValues(String sitePrefix, String value) {
        ArrayList<String> pathes;
        block6: {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return Collections.emptyList();
            }
            pathes = new ArrayList<String>();
            try {
                if (JSON.isValid((String)value)) {
                    List pathOptions = JSON.parseArray((String)value, PathOption.class);
                    for (int index = 0; index < pathOptions.size(); ++index) {
                        PathOption pathOption = (PathOption)pathOptions.get(index);
                        String originalPath = pathOption.getPath();
                        if (originalPath == null) continue;
                        if (!originalPath.startsWith("http")) {
                            originalPath = String.format("%s/obpm/%s", sitePrefix, originalPath).replace("//", "/");
                        }
                        pathes.add(originalPath);
                    }
                    break block6;
                }
                return Collections.singleton(value);
            }
            catch (Exception ex) {
                pathes.add(String.format("%s;\u5f02\u5e38:%s", value, ex.getMessage()));
                System.err.println(String.format("\u5f53\u524d\u7684\u503c\u4e3a:%s;\u8be6\u7ec6=%s", value, ExceptionUtils.getStackMessage((Throwable)ex)));
                ex.printStackTrace();
            }
        }
        return pathes;
    }

    static {
        ATTACHMENT_FILE_NAMES.add("url");
        ATTACHMENT_FILE_NAMES.add("img");
        ATTACHMENT_FILE_NAMES.add("attachment");
        ATTACHMENT_FILE_NAMES.add("upload");
        ATTACHMENT_FILE_NAMES.add("photo");
        ATTACHMENT_FILE_NAMES.add("image");
        ATTACHMENT_FILE_NAMES.add("file");
        ATTACHMENT_FILE_NAMES.add("path");
        ATTACHMENT_FILE_NAMES.add("picture");
        ATTACHMENT_FILE_NAMES.add("pirture");
    }

    public static class PathOption {
        private String path;
        private String name;
        private String originalPath;
        private String size;
        private String uid;

        public static PathOption create(String name, String path, String originalPath, String size, String uid) {
            PathOption option = new PathOption();
            option.setName(name);
            option.setPath(path);
            option.setOriginalPath(originalPath);
            option.setSize(size);
            option.setUid(uid);
            return option;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalPath() {
            return this.originalPath;
        }

        public String getSize() {
            return this.size;
        }

        public String getUid() {
            return this.uid;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOriginalPath(String originalPath) {
            this.originalPath = originalPath;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathOption)) {
                return false;
            }
            PathOption other = (PathOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$originalPath = this.getOriginalPath();
            String other$originalPath = other.getOriginalPath();
            if (this$originalPath == null ? other$originalPath != null : !this$originalPath.equals(other$originalPath)) {
                return false;
            }
            String this$size = this.getSize();
            String other$size = other.getSize();
            if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
                return false;
            }
            String this$uid = this.getUid();
            String other$uid = other.getUid();
            return !(this$uid == null ? other$uid != null : !this$uid.equals(other$uid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathOption;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $originalPath = this.getOriginalPath();
            result = result * 59 + ($originalPath == null ? 43 : $originalPath.hashCode());
            String $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : $size.hashCode());
            String $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
            return result;
        }

        public String toString() {
            return "FieldNames.PathOption(path=" + this.getPath() + ", name=" + this.getName() + ", originalPath=" + this.getOriginalPath() + ", size=" + this.getSize() + ", uid=" + this.getUid() + ")";
        }
    }
}

