package com.bcxin.runtime.apis.controllers;
import cn.myapps.common.auth.IUser;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.domains.dtos.RbacEmployeePermitAppDTO;
import com.bcxin.saas.domains.dtos.RbacQueryDTO;
import com.bcxin.saas.domains.readers.RbacDbReader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/api/runtime/currentuser")
public class CurrentUserController extends ControllerAbstract{
    private final RbacDbReader rbacDbReader;

    public CurrentUserController(RbacDbReader rbacDbReader) {
        this.rbacDbReader = rbacDbReader;
    }

    @GetMapping( "/rbac/apps")
    public ResponseEntity getPermitApps(@RequestParam("isMobile") boolean isMobile) throws Exception {
        try {
            IUser user = getWebUser();
            RbacQueryDTO rbacQueryDTO = RbacQueryDTO.create(user.getId(),
                    user.getDomainid(),
                    user.isDomainAdmin(),
                    isMobile,
                    null);
            RbacEmployeePermitAppDTO permitAppDTO = rbacDbReader.getPermitApps(rbacQueryDTO);
            return ResponseEntity.ok(permitAppDTO);
        } catch (Exception ex) {
            if (ex instanceof SaasNofoundException) {
                return ResponseEntity.status(HttpStatus.NOT_FOUND).body(ex.getMessage());
            }
            throw ex;
        }
    }
}
