/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.requests;

import cn.hutool.core.date.DateTime;
import com.bcxin.runtime.apis.dtos.SyncChangeLogTableDto;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DownChangelogRequest {
    private DateTime fromTime;
    private DateTime endTime;
    private String regionCode;
    private String regionName;
    private Collection<String> tables;
    private Map<String, String> dynamicParameterMaps;

    public void validate(HttpServletRequest servletRequest) {
        int amount = 600;
        String headValue = servletRequest.getHeader("skip_validation");
        if (StringUtils.hasLength((String)headValue) && new StringBuffer("skip_validation").reverse().toString().equals(headValue)) {
            amount = 3000;
        }
        Calendar supportedDate = Calendar.getInstance();
        supportedDate.add(5, 0 - amount);
        if (this.fromTime.before(supportedDate.getTime())) {
            throw new SaasNoSupportException(String.format("\u7cfb\u7edf\u53ea\u652f\u6301\u83b7\u53d6%s\u540e\u53d8\u66f4\u7684\u6570\u636e", new SimpleDateFormat("yyyy-MM-dd").format(supportedDate.getTime())));
        }
    }

    public boolean matched(SyncChangeLogTableDto changeLogTable) {
        if (!StringUtils.hasLength((String)this.getRegionCode()) || "govin-to-govout".equalsIgnoreCase(this.getRegionCode())) {
            // empty if block
        }
        if (CollectionUtils.isEmpty(this.getTables())) {
            return true;
        }
        if (!StringUtils.hasLength((String)changeLogTable.getTableName()) || changeLogTable == null) {
            return false;
        }
        return this.getTables().stream().anyMatch(ii -> ii.equalsIgnoreCase(changeLogTable.getTableName())) || this.getTables().stream().anyMatch(ix -> ix.equalsIgnoreCase(DownChangelogRequest.getAppTableName(changeLogTable.getAppId(), changeLogTable.getTableName())));
    }

    public static String getAppTableName(String appId, String tbName) {
        return String.format("%s|%s", appId, tbName);
    }

    public DateTime getFromTime() {
        return this.fromTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Collection<String> getTables() {
        return this.tables;
    }

    public Map<String, String> getDynamicParameterMaps() {
        return this.dynamicParameterMaps;
    }

    public void setFromTime(DateTime fromTime) {
        this.fromTime = fromTime;
    }

    public void setEndTime(DateTime endTime) {
        this.endTime = endTime;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setTables(Collection<String> tables) {
        this.tables = tables;
    }

    public void setDynamicParameterMaps(Map<String, String> dynamicParameterMaps) {
        this.dynamicParameterMaps = dynamicParameterMaps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownChangelogRequest)) {
            return false;
        }
        DownChangelogRequest other = (DownChangelogRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateTime this$fromTime = this.getFromTime();
        DateTime other$fromTime = other.getFromTime();
        if (this$fromTime == null ? other$fromTime != null : !this$fromTime.equals(other$fromTime)) {
            return false;
        }
        DateTime this$endTime = this.getEndTime();
        DateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$regionCode = this.getRegionCode();
        String other$regionCode = other.getRegionCode();
        if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
            return false;
        }
        String this$regionName = this.getRegionName();
        String other$regionName = other.getRegionName();
        if (this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName)) {
            return false;
        }
        Collection<String> this$tables = this.getTables();
        Collection<String> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables)) {
            return false;
        }
        Map<String, String> this$dynamicParameterMaps = this.getDynamicParameterMaps();
        Map<String, String> other$dynamicParameterMaps = other.getDynamicParameterMaps();
        return !(this$dynamicParameterMaps == null ? other$dynamicParameterMaps != null : !((Object)this$dynamicParameterMaps).equals(other$dynamicParameterMaps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownChangelogRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTime $fromTime = this.getFromTime();
        result = result * 59 + ($fromTime == null ? 43 : $fromTime.hashCode());
        DateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $regionCode = this.getRegionCode();
        result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
        String $regionName = this.getRegionName();
        result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
        Collection<String> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        Map<String, String> $dynamicParameterMaps = this.getDynamicParameterMaps();
        result = result * 59 + ($dynamicParameterMaps == null ? 43 : ((Object)$dynamicParameterMaps).hashCode());
        return result;
    }

    public String toString() {
        return "DownChangelogRequest(fromTime=" + this.getFromTime() + ", endTime=" + this.getEndTime() + ", regionCode=" + this.getRegionCode() + ", regionName=" + this.getRegionName() + ", tables=" + this.getTables() + ", dynamicParameterMaps=" + this.getDynamicParameterMaps() + ")";
    }
}

