/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.web.commons;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.TenantConfigProperty;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

public interface FileProcessor {
    public String save(MultipartFile var1);

    public String save(String var1);

    public static String getPath(String filename) {
        if (StrUtil.isEmpty((CharSequence)filename)) {
            throw new BadTenantException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return String.format("/uploads/%s/%s/%s", DateUtil.format((Date)new Date(), (String)"yyyy/MM-dd"), UUID.randomUUID(), filename);
    }

    @Component
    public static class FileProcessorImpl
    implements FileProcessor {
        private final Logger logger = LoggerFactory.getLogger(FileProcessorImpl.class);
        private final TenantConfigProperty configProperty;

        public FileProcessorImpl(TenantConfigProperty configProperty) {
            this.configProperty = configProperty;
        }

        @Override
        public String save(MultipartFile file) {
            String relativePath = FileProcessor.getPath(file.getOriginalFilename());
            String destFileName = String.format("%s%s", this.configProperty.getUpload().getPath(), relativePath);
            File destFile = new File(destFileName);
            FileUtil.mkdir((File)destFile.getParentFile());
            try {
                destFile.createNewFile();
                file.transferTo(destFile);
            }
            catch (IOException e) {
                throw new BadTenantException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
            }
            return relativePath;
        }

        @Override
        public String save(String bStream) {
            if (StringUtils.isEmpty((CharSequence)bStream)) {
                this.logger.info("2.BASE64-BadTenantException=\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                throw new BadTenantException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!bStream.startsWith("data:image/") || !bStream.contains(";base64,")) {
                this.logger.info("3.BASE64-BadTenantException=\u683c\u5f0f\u4e0d\u6b63\u786e");
                throw new BadTenantException("\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            this.logger.info("4.BASE64-save=star");
            String head = bStream.split(",")[0];
            String blob = bStream.split(",")[1];
            String imgSign = head.split(";")[0];
            String imgType = imgSign.split("/")[1];
            String filename = System.currentTimeMillis() + "." + imgType;
            String relativePath = FileProcessor.getPath(filename);
            this.logger.info("5.BASE64-save.relativePath=" + relativePath);
            String destFileName = String.format("%s%s", this.configProperty.getUpload().getPath(), relativePath);
            this.logger.info("6.BASE64-save.destFileName=" + destFileName);
            byte[] bytes = Base64.decodeBase64((String)blob);
            File destFile = new File(destFileName);
            FileUtil.mkdir((File)destFile.getParentFile());
            FileUtil.writeBytes((byte[])bytes, (File)destFile);
            this.logger.info("8.BASE64-save.result=" + relativePath);
            return relativePath;
        }
    }
}

