/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.dispatches.impls;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.dispatches.DispatchProperties;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchRequestAbstract;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchType;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Collection;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DataDispatcherImpl
implements DataDispatcher {
    private final DispatchProperties dispatchProperties;
    private final RetryProvider retryProvider;

    public DataDispatcherImpl(DispatchProperties dispatchProperties, RetryProvider retryProvider) {
        this.dispatchProperties = dispatchProperties;
        this.retryProvider = retryProvider;
    }

    @Override
    public void dispatch(DispatchRequestAbstract request) {
        if (StringUtils.hasLength((String)this.dispatchProperties.getApi())) {
            // empty if block
        }
    }

    protected HttpRequestBase getHttpRequestBase(DispatchRequestAbstract request) throws UnsupportedEncodingException {
        Collection<DispatchProperties.Certificate> certificates = this.dispatchProperties.getCertificates().get(request.getConfigKey());
        DispatchProperties.Certificate certificate = this.getCertificate(request.getDispatchType(), certificates);
        String clientId = certificate.getClientId();
        String secret = certificate.getSecret();
        String authString = String.format("%s:%s", clientId, secret);
        String authStringEnc = Base64.getEncoder().encodeToString(authString.getBytes("UTF-8"));
        HttpPost post = new HttpPost(this.dispatchProperties.getApi());
        post.setHeader("Authorization", String.format("Basic %s", authStringEnc));
        post.setHeader("Content-Type", "application/json");
        JSONObject body = new JSONObject();
        body.put("routeKey", (Object)certificate.getRouteKey());
        body.put("messageType", (Object)1);
        body.put("data", (Object)request.getPostData());
        StringEntity entity = new StringEntity(JSONObject.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "UTF-8");
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private DispatchProperties.Certificate getCertificate(DispatchType dispatchType, Collection<DispatchProperties.Certificate> certificates) {
        switch (dispatchType) {
            case Created: {
                DispatchProperties.Certificate createdCertificate = certificates.stream().filter(ii -> ii.getMethod().equals("created")).findFirst().get();
                if (createdCertificate == null) {
                    throw new ArgumentTenantException("created\u914d\u7f6e\u65e0\u6548!");
                }
                return createdCertificate;
            }
            case Edited: {
                DispatchProperties.Certificate editedCertificate = certificates.stream().filter(ii -> ii.getMethod().equals("edited")).findFirst().get();
                if (editedCertificate == null) {
                    throw new ArgumentTenantException("edited\u914d\u7f6e\u65e0\u6548!");
                }
                return editedCertificate;
            }
            case Deleted: {
                DispatchProperties.Certificate deletedCertificate = certificates.stream().filter(ii -> ii.getMethod().equals("deleted")).findFirst().get();
                if (deletedCertificate == null) {
                    throw new ArgumentTenantException("deleted!");
                }
                return deletedCertificate;
            }
        }
        throw new NotSupportTenantException("");
    }

    private /* synthetic */ void lambda$dispatch$0(DispatchRequestAbstract request) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpRequestBase requestBase = this.getHttpRequestBase(request);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)requestBase);
            int status = response.getStatusLine().getStatusCode();
            if (status == 401) {
                throw new UnAuthorizedTenantException("\u672a\u6388\u6743");
            }
            if (status < 200 || status > 300) {
                throw new BadTenantException(response.toString());
            }
        }
        catch (Exception ex) {
            throw new BadTenantException(ex.toString());
        }
    }
}

