/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.validations.CredentialValidator;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.events.TenantCredentialChangedValidateEvent;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import java.util.Collection;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TenantCredentialChangedEvent_EmployeeValidatorHandler
extends DomainEventHandlerAbstract<TenantCredentialChangedValidateEvent> {
    private final EmployeeRepository employeeRepository;
    private final TenantDbReader tenantDbReader;

    public TenantCredentialChangedEvent_EmployeeValidatorHandler(EmployeeRepository employeeRepository, TenantDbReader tenantDbReader) {
        this.employeeRepository = employeeRepository;
        this.tenantDbReader = tenantDbReader;
    }

    protected void execute(TenantCredentialChangedValidateEvent event) {
        Collection<EmployeeEntity> employeeEntities;
        if (event.getData() == null) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (event.getData() == CredentialType.IdCard) {
            if (!StringUtils.hasLength((String)event.getNumber())) {
                throw new ArgumentTenantException("\u8bc1\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CredentialValidator.validate((CredentialType)((CredentialType)event.getData()), (String)event.getNumber())) {
                throw new ArgumentTenantException(String.format("\u8bc1\u4ef6\u7f16\u53f7(%s)\u4e0d\u7b26\u5408\u8981\u6c42", event.getNumber()));
            }
        }
        if ((employeeEntities = this.employeeRepository.getSecurityGuardsByTenantUserId(event.getTenantUserId())).size() > 0) {
            if (event.getData() != CredentialType.IdCard) {
                throw new ArgumentTenantException("\u4fdd\u5b89\u5458\u53ea\u80fd\u63d0\u4ea4\u8eab\u4efd\u8bc1\u4ef6\u4fe1\u606f");
            }
            int age = CredentialValidator.getAge((String)event.getNumber());
            if (!event.isFromMobile() && age < 18) {
                throw new ArgumentTenantException("\u4fdd\u5b89\u5458\u5fc5\u987b\u4e0d\u5c0f\u4e8e18\u5c81");
            }
            String areaCode = "";
            for (EmployeeEntity employeeEntity : employeeEntities) {
                areaCode = employeeEntity.getOrganization().getSuperviseRegionCode();
                if (event.isFromMobile()) continue;
                employeeEntity.getOccupationType().validate(CredentialType.IdCard, event.getNumber(), areaCode, employeeEntity.getOrganization().getInstitutionalCode());
            }
        }
    }
}

