/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.tenant.domain.entities.OrganizationStatisticsReportEntity;
import com.bcxin.tenant.domain.repositories.OrganizationStatisticsReportsRepository;
import com.bcxin.tenant.domain.services.OrganizationStatisticsService;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrganizationStatisticsServiceImpl
implements OrganizationStatisticsService {
    private final Logger logger = LoggerFactory.getLogger(OrganizationStatisticsServiceImpl.class);
    private final OrganizationStatisticsReportsRepository organizationStatisticsReportsRepository;
    private final UnitWork unitWork;

    public OrganizationStatisticsServiceImpl(OrganizationStatisticsReportsRepository organizationStatisticsReportsRepository, UnitWork unitWork) {
        this.organizationStatisticsReportsRepository = organizationStatisticsReportsRepository;
        this.unitWork = unitWork;
    }

    @Override
    public void createStatisticsById(Collection<String> orgIds) {
        if (Collections.isEmpty(orgIds)) {
            this.logger.error("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String transId = this.unitWork.beginTransaction();
        try {
            if (!Collections.isEmpty(orgIds)) {
                List createOrUpdateEntities = this.organizationStatisticsReportsRepository.getOrganizationStatisticsInfo(orgIds).stream().map(ix -> OrganizationStatisticsReportEntity.create(ix.getOrgId(), ix.getUnifySocialCreditCode(), ix.getCountOfMembers())).collect(Collectors.toList());
                this.organizationStatisticsReportsRepository.saveAll(createOrUpdateEntities);
            }
            this.unitWork.commit(transId);
        }
        catch (Exception e) {
            this.unitWork.rollback(transId);
            this.logger.error(String.format("\u6dfb\u52a0\u7ec4\u7ec7\u7edf\u8ba1\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38\uff1a%s", e.getMessage()));
        }
    }

    @Override
    public void syncOrganizationStatistics() {
        String transId = this.unitWork.beginTransaction();
        try {
            List<OrganizationStatisticsReportEntity> orgEntities = this.organizationStatisticsReportsRepository.findAll();
            if (!Collections.isEmpty(orgEntities)) {
                List<String> orgIds = orgEntities.stream().map(ix -> ix.getId()).collect(Collectors.toList());
                List updateEntities = this.organizationStatisticsReportsRepository.getOrganizationStatisticsInfo(orgIds).stream().map(ix -> OrganizationStatisticsReportEntity.create(ix.getOrgId(), ix.getUnifySocialCreditCode(), ix.getCountOfMembers())).collect(Collectors.toList());
                this.organizationStatisticsReportsRepository.saveAll(updateEntities);
            }
            this.unitWork.commit(transId);
        }
        catch (Exception e) {
            this.unitWork.rollback(transId);
            this.logger.error(String.format("\u66f4\u65b0\u7ec4\u7ec7\u7edf\u8ba1\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38\uff1a%s", e.getMessage()));
        }
    }
}

