/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.InvitedStatus;
import com.bcxin.Infrastructures.enums.InvitedType;
import com.bcxin.Infrastructures.exceptions.AbnormalPersonnelException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.Infrastructures.models.AbnormalPersonnelListDto;
import com.bcxin.Infrastructures.models.CredentialModel;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.api.interfaces.identities.requests.InvitedToJoinQueuesRequest;
import com.bcxin.api.interfaces.security.AttendSitePersonRpcProvider;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.InviteAttendSiteRpcProvider;
import com.bcxin.api.interfaces.tenants.InviteDepartRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.employees.EmployeeRequest;
import com.bcxin.api.interfaces.tenants.responses.InviteAttendSiteResponse;
import com.bcxin.api.interfaces.tenants.responses.InviteDepartResponse;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.InvitedToJoinQueuesEntity;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.InvitedToJoinQueuesRepository;
import com.bcxin.tenant.domain.services.InvitedToJoinQueuesService;
import com.bcxin.tenant.domain.services.commands.InvitedToJoinQueuesCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.stereotype.Service;

@Service
public class InvitedToJoinQueuesServiceImpl
implements InvitedToJoinQueuesService {
    private final InvitedToJoinQueuesRepository invitedToJoinQueuesRepository;
    private final InviteDepartRpcProvider inviteDepartRpcProvider;
    private final DepartmentRepository departmentRepository;
    private final InviteAttendSiteRpcProvider inviteAttendSiteRpcProvider;
    private final UnitWork unitWork;
    private final TenantDbReader dbReader;
    private final EmployeeRpcProvider employeeRpcProvider;
    private final AttendSitePersonRpcProvider attendSitePersonRpcProvider;

    public InvitedToJoinQueuesServiceImpl(InvitedToJoinQueuesRepository invitedToJoinQueuesRepository, InviteDepartRpcProvider inviteDepartRpcProvider, DepartmentRepository departmentRepository, InviteAttendSiteRpcProvider inviteAttendSiteRpcProvider, UnitWork unitWork, TenantDbReader dbReader, EmployeeRpcProvider employeeRpcProvider, AttendSitePersonRpcProvider attendSitePersonRpcProvider) {
        this.invitedToJoinQueuesRepository = invitedToJoinQueuesRepository;
        this.inviteDepartRpcProvider = inviteDepartRpcProvider;
        this.departmentRepository = departmentRepository;
        this.inviteAttendSiteRpcProvider = inviteAttendSiteRpcProvider;
        this.unitWork = unitWork;
        this.dbReader = dbReader;
        this.employeeRpcProvider = employeeRpcProvider;
        this.attendSitePersonRpcProvider = attendSitePersonRpcProvider;
    }

    @Override
    public void dispatch(InvitedToJoinQueuesCommand invitedToJoinQueuesCommand) {
        DepartmentEntity department = this.departmentRepository.findById(invitedToJoinQueuesCommand.getDepartmentId()).orElse(null);
        if (department == null || department.isDeleted()) {
            throw new NotFoundTenantException("\u8be5\u90e8\u95e8\u4fe1\u606f\u65e0\u6548");
        }
        OperatorValueType operatorValueType = null;
        String organizationId = null;
        String attendanceSiteName = null;
        String attendanceSiteId = null;
        if (invitedToJoinQueuesCommand.getInvitedType() == InvitedType.InviteDepart) {
            InviteDepartResponse inviteDepart = this.inviteDepartRpcProvider.getUnOvertime(invitedToJoinQueuesCommand.getInviteId());
            if (inviteDepart == null) {
                throw new NotFoundTenantException("\u8be5\u9080\u8bf7\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u622a\u6b62\uff01");
            }
            if (!invitedToJoinQueuesCommand.getDepartmentId().equals(inviteDepart.getDepartId())) {
                throw new NotSupportTenantException("\u90e8\u95e8\u4e0e\u9080\u8bf7\u4e0d\u7b26\uff01");
            }
            if (!invitedToJoinQueuesCommand.getOccupationType().equals((Object)inviteDepart.getOccupationType())) {
                throw new NotSupportTenantException("\u804c\u4e1a\u7c7b\u578b\u4e0e\u9080\u8bf7\u4e0d\u7b26\uff01");
            }
            operatorValueType = inviteDepart.getCreator();
            organizationId = inviteDepart.getOrganizationId();
        } else if (invitedToJoinQueuesCommand.getInvitedType() == InvitedType.InviteAttend) {
            InviteAttendSiteResponse inviteAttendSite = this.inviteAttendSiteRpcProvider.getUnOvertime(invitedToJoinQueuesCommand.getInviteId());
            if (inviteAttendSite == null) {
                throw new NotFoundTenantException("\u8be5\u9080\u8bf7\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u622a\u6b62\uff01");
            }
            if (!invitedToJoinQueuesCommand.getDepartmentId().equals(inviteAttendSite.getDepartId())) {
                throw new NotSupportTenantException("\u90e8\u95e8\u4e0e\u9080\u8bf7\u4e0d\u7b26\uff01");
            }
            if (!invitedToJoinQueuesCommand.getOccupationType().equals((Object)inviteAttendSite.getOccupationType())) {
                throw new NotSupportTenantException("\u804c\u4e1a\u7c7b\u578b\u4e0e\u9080\u8bf7\u4e0d\u7b26\uff01");
            }
            operatorValueType = inviteAttendSite.getCreator();
            organizationId = inviteAttendSite.getOrganizationId();
            attendanceSiteName = inviteAttendSite.getAttendSiteName();
            attendanceSiteId = inviteAttendSite.getAttendSiteId();
        } else {
            throw new NotSupportTenantException("\u9080\u8bf7\u7c7b\u578b\u4e0d\u7b26\uff01");
        }
        AtomicReference invitedAto = new AtomicReference();
        OperatorValueType finalOperatorValueType = operatorValueType;
        String finalOrganizationId = organizationId;
        String finalAttendanceSiteName = attendanceSiteName;
        String finalAttendanceSiteId = attendanceSiteId;
        this.unitWork.executeTran(() -> {
            invitedAto.set(InvitedToJoinQueuesEntity.create(invitedToJoinQueuesCommand.getName(), invitedToJoinQueuesCommand.getTelephone(), invitedToJoinQueuesCommand.getCredentialType(), invitedToJoinQueuesCommand.getCredentialNumber(), finalOperatorValueType, invitedToJoinQueuesCommand.getInvitedType(), invitedToJoinQueuesCommand.getDepartmentId(), department.getName(), finalOrganizationId, invitedToJoinQueuesCommand.getOccupationType(), finalAttendanceSiteName, finalAttendanceSiteId, invitedToJoinQueuesCommand.getInvitedStatus(), invitedToJoinQueuesCommand.getLastOperatorId(), invitedToJoinQueuesCommand.getLastOperatorName()));
            this.invitedToJoinQueuesRepository.save((EntityAbstract)invitedAto.get());
        });
    }

    @Override
    public void update(InvitedToJoinQueuesRequest request) {
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        Collection<InvitedToJoinQueuesEntity> invitedToJoinQueuesEntities = this.invitedToJoinQueuesRepository.findByIds(request.getIds());
        StringBuffer exceptionMsg = new StringBuffer();
        HashMap<String, AbnormalPersonnelListDto> exceptionMap = new HashMap<String, AbnormalPersonnelListDto>();
        for (InvitedToJoinQueuesEntity invitedToJoinQueuesEntity : invitedToJoinQueuesEntities) {
            try {
                if (InvitedStatus.Agree.equals((Object)request.getInvitedStatus())) {
                    EmployeeRequest employeeRequest = new EmployeeRequest();
                    employeeRequest.setName(invitedToJoinQueuesEntity.getName());
                    employeeRequest.setTelephone(invitedToJoinQueuesEntity.getTelephone());
                    employeeRequest.setDepartId(invitedToJoinQueuesEntity.getDepartmentId());
                    employeeRequest.setCredential(CredentialModel.create((CredentialType)invitedToJoinQueuesEntity.getCredentialType(), (String)invitedToJoinQueuesEntity.getCredentialNumber()));
                    employeeRequest.setPosition(null);
                    employeeRequest.setHiredDate((Date)DateUtil.beginOfDay((Date)new Date()));
                    employeeRequest.setOccupationType(invitedToJoinQueuesEntity.getOccupationType());
                    employeeRequest.setAbnormalPersonnelConfirm(request.getAbnormalPersonnelConfirm());
                    employeeRequest.setOperator(AuthUtil.getCurrentOperator());
                    String employeeId = this.employeeRpcProvider.create(invitedToJoinQueuesEntity.getOrganizationId(), employeeRequest);
                    if (InvitedType.InviteAttend.equals((Object)invitedToJoinQueuesEntity.getInvitedType())) {
                        InviteAttendSiteResponse inviteAttendSite = new InviteAttendSiteResponse();
                        inviteAttendSite.setAttendSiteId(invitedToJoinQueuesEntity.getAttendanceSiteId());
                        inviteAttendSite.setDepartId(invitedToJoinQueuesEntity.getDepartmentId());
                        inviteAttendSite.setDepartName(invitedToJoinQueuesEntity.getDepartmentName());
                        inviteAttendSite.setOrganizationId(invitedToJoinQueuesEntity.getOrganizationId());
                        this.attendSitePersonRpcProvider.create(inviteAttendSite, employeeRequest, employeeId);
                    }
                }
                this.unitWork.executeTran(() -> {
                    invitedToJoinQueuesEntity.change(request.getInvitedStatus(), currentUser.getEmployeeId(), currentUser.getName());
                    this.invitedToJoinQueuesRepository.save(invitedToJoinQueuesEntity);
                });
            }
            catch (AbnormalPersonnelException e) {
                AbnormalPersonnelListDto dto = (AbnormalPersonnelListDto)exceptionMap.get(e.getCode());
                if (dto == null) {
                    dto = new AbnormalPersonnelListDto();
                    dto.setCode(e.getCode());
                    if ("1000601".equals(e.getCode())) {
                        dto.setMsg("\u4eba\u5458\u4e3a\u4ece\u4e1a\u5f02\u5e38\u4eba\u5458\uff0c\u662f\u5426\u786e\u8ba4\u5f55\u7528\uff01");
                    } else {
                        dto.setMsg("\u4eba\u5458\u4e0d\u7b26\u5408\u62c5\u4efb\u4fdd\u5b89\u5458\uff0c\u65e0\u6cd5\u5f55\u5165\u7cfb\u7edf\uff01");
                    }
                }
                dto.addId(invitedToJoinQueuesEntity.getId());
                exceptionMap.put(e.getCode(), dto);
            }
        }
        if (exceptionMap.size() > 0) {
            throw new AbnormalPersonnelException("1000600", "\u5f02\u5e38\u4eba\u5458\u5165\u804c\u6279\u91cf\u63d0\u9192", new ArrayList(exceptionMap.values()));
        }
    }
}

