/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.dto.EmployeeOccupationTypeValidationBasicDto;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.events.EmployeeBeforeEntryValidationEvent;
import com.bcxin.tenant.domain.exceptions.EntryEmployeeValidationException;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class EmployeeBeforeEntryValidationEvent_ValidationHandler
extends DomainEventHandlerAbstract<EmployeeBeforeEntryValidationEvent> {
    private final TenantDbReader dbReader;
    private final OrganizationRepository organizationRepository;
    private final EnvConfig envConfig;

    public EmployeeBeforeEntryValidationEvent_ValidationHandler(TenantDbReader dbReader, EnvConfig envConfig, OrganizationRepository organizationRepository) {
        this.dbReader = dbReader;
        this.envConfig = envConfig;
        this.organizationRepository = organizationRepository;
    }

    protected void execute(EmployeeBeforeEntryValidationEvent event) {
        ArrayList<EntryEmployeeValidationException.EntryNotAllowedInfo> notAllowedCompanyInfos = new ArrayList<EntryEmployeeValidationException.EntryNotAllowedInfo>();
        ArrayList<String> preMatchTenantUserIds = new ArrayList<String>();
        for (EmployeeBeforeEntryValidationEvent.TenantUserOccupationTypeInfo userOccupationTypeInfo : event.getTenantUsers()) {
            try {
                if (userOccupationTypeInfo.getOccupationType() == OccupationType.SecurityGuard && userOccupationTypeInfo.getCredentialType() != CredentialType.IdCard) {
                    throw new ArgumentTenantException(String.format("%s \u590d\u804c\u4e3a\u4fdd\u5b89\u4eba\u5458\u7684\u65f6\u5019, \u8bc1\u4ef6\u7c7b\u578b\u5fc5\u987b\u4e3a\u8eab\u4efd\u8bc1", userOccupationTypeInfo.getName()));
                }
                if (userOccupationTypeInfo.getCredentialType() == CredentialType.IdCard) {
                    Optional organizationOptional = this.organizationRepository.findById(event.getOrganizationId());
                    userOccupationTypeInfo.getOccupationType().validate(userOccupationTypeInfo.getCredentialType(), userOccupationTypeInfo.getCredentialNumber(), event.getAreaCode(), (String)organizationOptional.map(OrganizationEntity::getInstitutionalCode).orElse(null));
                }
                preMatchTenantUserIds.add(userOccupationTypeInfo.getTenantUserId());
            }
            catch (Exception ex) {
                notAllowedCompanyInfos.add(EntryEmployeeValidationException.EntryNotAllowedInfo.create(userOccupationTypeInfo.getName(), ex.getMessage(), userOccupationTypeInfo.getTelephone(), userOccupationTypeInfo.getCredentialType(), userOccupationTypeInfo.getCredentialNumber()));
            }
        }
        Collection<EmployeeOccupationTypeValidationBasicDto> allEmployeeOccupationTypeValidationBasics = this.dbReader.getOnDutyEmployeeValidationDtoByIdsAndAreaCode(event.getAreaCode(), event.getOrganizationId(), preMatchTenantUserIds);
        if (!CollectionUtils.isEmpty(allEmployeeOccupationTypeValidationBasics)) {
            Collection employeeOccupationTypeValidationBasics = allEmployeeOccupationTypeValidationBasics.stream().filter(ii -> !ii.getOrganizationId().equalsIgnoreCase(event.getOrganizationId())).collect(Collectors.toList());
            for (EmployeeBeforeEntryValidationEvent.TenantUserOccupationTypeInfo tenantUserOccupationTypeInfo : event.getTenantUsers()) {
                String dutyCompanyName;
                EmployeeOccupationTypeValidationBasicDto currentEmployee = allEmployeeOccupationTypeValidationBasics.stream().filter(ii -> ii.getOrganizationId().equalsIgnoreCase(event.getOrganizationId()) && ii.getStatus() == EmploymentStatus.OnJob).findFirst().orElse(null);
                if (currentEmployee != null) {
                    notAllowedCompanyInfos.add(EntryEmployeeValidationException.EntryNotAllowedInfo.create(tenantUserOccupationTypeInfo.getName(), "\u8be5\u804c\u5458\u5df2\u5728\u804c, \u8bf7\u52ff\u91cd\u590d\u5165\u804c", tenantUserOccupationTypeInfo.getTelephone(), tenantUserOccupationTypeInfo.getCredentialType(), tenantUserOccupationTypeInfo.getCredentialNumber()));
                }
                if (tenantUserOccupationTypeInfo.getOccupationType() == OccupationType.Normal) {
                    dutyCompanyName = employeeOccupationTypeValidationBasics.stream().filter(ix -> ix.getOccupationType() == OccupationType.SecurityGuard && ix.getTenantUserId().equalsIgnoreCase(tenantUserOccupationTypeInfo.getTenantUserId())).map(ii -> ii.getOrganizationName()).distinct().collect(Collectors.joining(","));
                    if (!StringUtils.hasLength((String)dutyCompanyName)) continue;
                    notAllowedCompanyInfos.add(EntryEmployeeValidationException.EntryNotAllowedInfo.create(tenantUserOccupationTypeInfo.getName(), String.format(" \u5728(%s)\u516c\u53f8\u4ee5\u4fdd\u5b89\u5458\u8eab\u4efd\u5728\u804c, \u56e0\u6b64, \u65e0\u6cd5\u5165\u804c\u4e00\u822c\u804c\u5458, \u8bf7\u8054\u7cfb\u4ee5\u4e0a\u516c\u53f8\u529e\u7406\u79bb\u804c\u4e4b\u540e, \u91cd\u65b0\u5728\u672c\u516c\u53f8\u5165\u804c!", dutyCompanyName), tenantUserOccupationTypeInfo.getTelephone(), tenantUserOccupationTypeInfo.getCredentialType(), tenantUserOccupationTypeInfo.getCredentialNumber()));
                    continue;
                }
                if (tenantUserOccupationTypeInfo.getOccupationType() != OccupationType.SecurityGuard) continue;
                dutyCompanyName = employeeOccupationTypeValidationBasics.stream().filter(ix -> ix.getOccupationType() == OccupationType.Normal && ix.getTenantUserId().equalsIgnoreCase(tenantUserOccupationTypeInfo.getTenantUserId())).map(ii -> ii.getOrganizationName()).distinct().collect(Collectors.joining(","));
                String dutySecurityGuardCompanyName = employeeOccupationTypeValidationBasics.stream().filter(ix -> ix.getOccupationType() == OccupationType.SecurityGuard && ix.getTenantUserId().equalsIgnoreCase(tenantUserOccupationTypeInfo.getTenantUserId())).map(ii -> ii.getOrganizationName()).distinct().collect(Collectors.joining(","));
                if (!StringUtils.hasLength((String)dutyCompanyName) && !StringUtils.hasLength((String)dutySecurityGuardCompanyName)) continue;
                String message = null;
                if (StringUtils.hasLength((String)dutyCompanyName)) {
                    message = String.format(" \u5728(%s)\u516c\u53f8\u4ee5\u4e00\u822c\u804c\u5458\u8eab\u4efd\u5728\u804c, \u56e0\u6b64, \u65e0\u6cd5\u5165\u804c\u4fdd\u5b89\u5458, \u8bf7\u8054\u7cfb\u4ee5\u4e0a\u516c\u53f8\u529e\u7406\u79bb\u804c\u4e4b\u540e, \u91cd\u65b0\u5728\u672c\u516c\u53f8\u5165\u804c!", dutyCompanyName);
                }
                if (StringUtils.hasLength((String)dutySecurityGuardCompanyName)) {
                    message = String.format(" \u5728(%s)\u516c\u53f8\u4ee5\u4fdd\u5b89\u5458\u4efd\u5728\u804c, \u56e0\u6b64, \u65e0\u6cd5\u518d\u6b21\u5165\u804c\u4fdd\u5b89\u5458, \u8bf7\u8054\u7cfb\u4ee5\u4e0a\u516c\u53f8\u529e\u7406\u79bb\u804c\u4e4b\u540e, \u91cd\u65b0\u5728\u672c\u516c\u53f8\u5165\u804c!", dutySecurityGuardCompanyName);
                }
                notAllowedCompanyInfos.add(EntryEmployeeValidationException.EntryNotAllowedInfo.create(tenantUserOccupationTypeInfo.getName(), message, tenantUserOccupationTypeInfo.getTelephone(), tenantUserOccupationTypeInfo.getCredentialType(), tenantUserOccupationTypeInfo.getCredentialNumber()));
            }
        }
        if (!CollectionUtils.isEmpty(notAllowedCompanyInfos)) {
            throw new EntryEmployeeValidationException("", notAllowedCompanyInfos);
        }
    }
}

