/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.AppealStatus;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="tenant_user_appeals")
@Entity
public class TenantUserAppealsEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="tenant_user_id", referencedColumnName="id")
    private TenantUserEntity tenantUser;
    @Column(name="region_code")
    private String regionCode;
    @Column(name="appeal_photo")
    private String appeal_photo;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status")
    private AppealStatus status;
    @Column(name="result")
    private String result;
    @Column(name="last_approver_depart_name")
    private String lastApproverDepartName;
    @Column(name="last_approver_name")
    private String lastApproverName;
    @Column(name="last_approver_time")
    private Timestamp lastApproverTime;
    @Column(name="last_updated_time")
    private Timestamp lastUpdatedTime;
    @Column(nullable=false, name="created_time")
    private Timestamp createdTime;

    public static TenantUserAppealsEntity create(TenantUserEntity tenantUser, String appeal_photo, String regionCode) {
        TenantUserAppealsEntity tenantUserAppealsEntity = new TenantUserAppealsEntity();
        tenantUserAppealsEntity.setTenantUser(tenantUser);
        tenantUserAppealsEntity.setAppeal_photo(appeal_photo);
        tenantUserAppealsEntity.setRegionCode(regionCode);
        tenantUserAppealsEntity.setStatus(AppealStatus.Request);
        tenantUserAppealsEntity.setCreatedTime(Timestamp.from(Instant.now()));
        tenantUserAppealsEntity.setLastUpdatedTime(Timestamp.from(Instant.now()));
        return tenantUserAppealsEntity;
    }

    public Long getId() {
        return this.id;
    }

    public TenantUserEntity getTenantUser() {
        return this.tenantUser;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public String getAppeal_photo() {
        return this.appeal_photo;
    }

    public AppealStatus getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public String getLastApproverDepartName() {
        return this.lastApproverDepartName;
    }

    public String getLastApproverName() {
        return this.lastApproverName;
    }

    public Timestamp getLastApproverTime() {
        return this.lastApproverTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    protected void setTenantUser(TenantUserEntity tenantUser) {
        this.tenantUser = tenantUser;
    }

    protected void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    protected void setAppeal_photo(String appeal_photo) {
        this.appeal_photo = appeal_photo;
    }

    protected void setStatus(AppealStatus status) {
        this.status = status;
    }

    protected void setResult(String result) {
        this.result = result;
    }

    protected void setLastApproverDepartName(String lastApproverDepartName) {
        this.lastApproverDepartName = lastApproverDepartName;
    }

    protected void setLastApproverName(String lastApproverName) {
        this.lastApproverName = lastApproverName;
    }

    protected void setLastApproverTime(Timestamp lastApproverTime) {
        this.lastApproverTime = lastApproverTime;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }
}

