/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.enums.CompanyCertificateType;
import com.bcxin.Infrastructures.enums.CompanyNature;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EconomicType;
import com.bcxin.Infrastructures.enums.SecurityArmedRating;
import com.bcxin.Infrastructures.enums.SecurityPreparednessRating;
import com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating;
import com.bcxin.Infrastructures.utils.StringUtils;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.services.commands.organizations.CreateMyOrganizationCommand;
import com.bcxin.tenant.domain.services.commands.organizations.RegisterCompanyCommand;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.collections4.CollectionUtils;

@Table(name="tenant_companies")
@Entity
public class CompanyEntity
extends EntityAbstract {
    @Id
    private String id;
    @Column(name="unify_social_credit_code", nullable=false)
    private String unifySocialCreditCode;
    @Column(name="unify_social_credit_code_file", nullable=false)
    private String unifySocialCreditCodeFile;
    @Column(name="parent_name")
    private String parentName;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="parent_certificate_type")
    private CompanyCertificateType parentCertificateType;
    @Column(name="parent_certificate_number")
    private String parentCertificateNumber;
    @Column(name="parent_legal_person_name")
    private String parentLegalPersonName;
    @Column(name="parent_legal_person_telephone")
    private String parentLegalPersonTelephone;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="economic_type")
    private EconomicType economicType;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="nature")
    private CompanyNature nature;
    @Column(name="service_scope")
    private Integer serviceScope;
    @Column(name="service_scope_description")
    private String serviceScopeDescription;
    @Column(name="registered_capital")
    private String registeredCapital;
    @Column(name="fixed_capital")
    private String fixedCapital;
    @Column(name="annual_profit_tax")
    private String annualProfitTax;
    @Column(name="annual_sales_volume")
    private String annualSalesVolume;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="certificate_type")
    private CompanyCertificateType certificateType;
    @Column(name="service_permit_number")
    private String servicePermitNumber;
    @Column(name="security_approval_number")
    private String securityApprovalNumber;
    @Column(name="name_of_issuing_authority")
    private String nameOfIssuingAuthority;
    @Column(name="first_issue_service_permit")
    private Date firstIssueServicePermit;
    @Column(name="service_permit_attachment")
    private String servicePermitAttachment;
    @Column(name="train_content")
    private String trainContent;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="security_preparedness_rating")
    private SecurityPreparednessRating securityPreparednessRating;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="security_armed_rating")
    private SecurityArmedRating securityArmedRating;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="security_safety_defense_rating")
    private SecuritySafetyDefenseRating securitySafetyDefenseRating;
    @Column(name="is_risk_assessment")
    private Boolean isRiskAssessment;
    @Column(name="number_of_security_guards")
    private Integer numberOfSecurityGuards;
    @Column(name="is_public_security_security")
    private Boolean isPublicSecuritySecurity;
    @Column(name="is_property_enterprise")
    private Boolean isPropertyEnterprise;
    @Column(name="nature_of_self_recruited_units")
    private String natureOfSelfRecruitedUnits;
    @Column(name="legal_person_name")
    private String legalPersonName;
    @Column(name="legal_person_telephone")
    private String legalPersonTelephone;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="legal_person_credential_type")
    private CredentialType legalPersonCredentialType;
    @Column(name="legal_person_credential_number")
    private String legalPersonCredentialNumber;
    @Column(name="legal_person_nationality")
    private String legalPersonNationality;
    @Column(name="security_person_name")
    private String securityPersonName;
    @Column(name="security_person_telephone")
    private String securityPersonTelephone;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="security_person_credential_type")
    private CredentialType securityPersonCredentialType;
    @Column(name="security_person_credential_number")
    private String securityPersonCredentialNumber;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="last_updated_time")
    private Date lastUpdatedTime;

    public CompanyEntity() {
    }

    public CompanyEntity(OrganizationEntity organization) {
        this.setId(organization.getId());
    }

    public CompanyEntity(OrganizationEntity organization, String unifySocialCreditCode, String unifySocialCreditCodeFile, String parentName, CompanyCertificateType parentCertificateType, String parentCertificateNumber, String parentLegalPersonName, String parentLegalPersonTelephone, EconomicType economicType, CompanyNature nature, Integer serviceScope, String serviceScopeDescription, String registeredCapital, String fixedCapital, String annualProfitTax, String annualSalesVolume, CompanyCertificateType certificateType, String servicePermitNumber, String securityApprovalNumber, String nameOfIssuingAuthority, Date firstIssueServicePermit, String servicePermitAttachment, String trainContent, SecurityPreparednessRating securityPreparednessRating, SecurityArmedRating securityArmedRating, SecuritySafetyDefenseRating securitySafetyDefenseRating, Boolean isRiskAssessment, Integer numberOfSecurityGuards, Boolean isPublicSecuritySecurity, Boolean isPropertyEnterprise, String natureOfSelfRecruitedUnits, String legalPersonName, String legalPersonTelephone, CredentialType legalPersonCredentialType, String legalPersonCredentialNumber, String legalPersonNationality, String securityPersonName, String securityPersonTelephone, CredentialType securityPersonCredentialType, String securityPersonCredentialNumber) {
        this.setId(organization.getId());
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.parentName = parentName;
        this.parentCertificateType = parentCertificateType;
        this.parentCertificateNumber = parentCertificateNumber;
        this.parentLegalPersonName = parentLegalPersonName;
        this.parentLegalPersonTelephone = parentLegalPersonTelephone;
        this.economicType = economicType == null ? EconomicType.None : economicType;
        this.nature = nature;
        this.serviceScope = serviceScope;
        this.serviceScopeDescription = serviceScopeDescription;
        this.registeredCapital = registeredCapital == null ? "" : registeredCapital;
        this.fixedCapital = fixedCapital;
        this.annualProfitTax = annualProfitTax;
        this.annualSalesVolume = annualSalesVolume;
        this.certificateType = certificateType;
        this.servicePermitNumber = servicePermitNumber;
        this.securityApprovalNumber = securityApprovalNumber;
        this.nameOfIssuingAuthority = nameOfIssuingAuthority;
        this.firstIssueServicePermit = firstIssueServicePermit;
        this.servicePermitAttachment = servicePermitAttachment;
        this.trainContent = trainContent;
        this.securityPreparednessRating = securityPreparednessRating;
        this.securityArmedRating = securityArmedRating;
        this.securitySafetyDefenseRating = securitySafetyDefenseRating;
        this.isRiskAssessment = isRiskAssessment;
        this.numberOfSecurityGuards = numberOfSecurityGuards;
        this.isPublicSecuritySecurity = isPublicSecuritySecurity;
        this.isPropertyEnterprise = isPropertyEnterprise;
        this.natureOfSelfRecruitedUnits = natureOfSelfRecruitedUnits;
        this.legalPersonName = legalPersonName == null ? "" : legalPersonName;
        this.legalPersonTelephone = legalPersonTelephone == null ? "" : legalPersonTelephone;
        this.legalPersonCredentialType = legalPersonCredentialType == null ? CredentialType.IdCard : legalPersonCredentialType;
        this.legalPersonCredentialNumber = legalPersonCredentialNumber == null ? "" : legalPersonCredentialNumber;
        this.legalPersonNationality = legalPersonNationality == null ? "" : legalPersonNationality;
        this.securityPersonName = securityPersonName;
        this.securityPersonTelephone = securityPersonTelephone;
        this.securityPersonCredentialType = securityPersonCredentialType;
        this.securityPersonCredentialNumber = securityPersonCredentialNumber;
        this.createTime = new Date();
    }

    public void change(String unifySocialCreditCode, String unifySocialCreditCodeFile, String parentName, CompanyCertificateType parentCertificateType, String parentCertificateNumber, String parentLegalPersonName, String parentLegalPersonTelephone, EconomicType economicType, CompanyNature nature, List<String> serviceScopeList, String registeredCapital, String fixedCapital, String annualProfitTax, String annualSalesVolume, CompanyCertificateType certificateType, String servicePermitNumber, String securityApprovalNumber, String nameOfIssuingAuthority, Date firstIssueServicePermit, String servicePermitAttachment, String trainContent, SecurityPreparednessRating securityPreparednessRating, SecurityArmedRating securityArmedRating, SecuritySafetyDefenseRating securitySafetyDefenseRating, Boolean isRiskAssessment, Integer numberOfSecurityGuards, Boolean isPublicSecuritySecurity, Boolean isPropertyEnterprise, String natureOfSelfRecruitedUnits, String legalPersonName, String legalPersonTelephone, CredentialType legalPersonCredentialType, String legalPersonCredentialNumber, String legalPersonNationality, String securityPersonName, String securityPersonTelephone, CredentialType securityPersonCredentialType, String securityPersonCredentialNumber) {
        Integer serviceScope = null;
        String serviceScopeDescription = null;
        StringBuffer serviceScopeDescriptionSb = new StringBuffer();
        if (CollectionUtils.isNotEmpty(serviceScopeList)) {
            int serviceScopeInt = 0;
            for (String scope : serviceScopeList) {
                int s = Integer.parseInt(scope);
                serviceScopeDescriptionSb.append(scope).append(";");
                serviceScopeInt = (int)((double)serviceScopeInt + Math.pow(2.0, s - 1));
            }
            serviceScope = serviceScopeInt;
            serviceScopeDescription = serviceScopeDescriptionSb.substring(0, serviceScopeDescriptionSb.length() - 1);
        }
        if (economicType != null) {
            this.setEconomicType(economicType);
        }
        if (nature != null) {
            this.setNature(nature);
        }
        if (parentName != null) {
            this.setParentName(parentName);
        }
        if (parentCertificateType != null) {
            this.setParentCertificateType(parentCertificateType);
        }
        if (parentCertificateNumber != null) {
            this.setParentCertificateNumber(parentCertificateNumber);
        }
        if (parentLegalPersonName != null) {
            this.setParentLegalPersonName(parentLegalPersonName);
        }
        if (parentLegalPersonTelephone != null) {
            this.setParentLegalPersonTelephone(parentLegalPersonTelephone);
        }
        if (registeredCapital != null) {
            this.setRegisteredCapital(registeredCapital);
        }
        if (fixedCapital != null) {
            this.setFixedCapital(fixedCapital);
        }
        if (annualSalesVolume != null) {
            this.setAnnualSalesVolume(annualSalesVolume);
        }
        if (annualProfitTax != null) {
            this.setAnnualProfitTax(annualProfitTax);
        }
        if (certificateType != null) {
            this.setCertificateType(certificateType);
        }
        if (unifySocialCreditCode != null) {
            this.setUnifySocialCreditCode(unifySocialCreditCode);
        }
        if (unifySocialCreditCodeFile != null) {
            this.setUnifySocialCreditCodeFile(unifySocialCreditCodeFile);
        }
        if (servicePermitNumber != null) {
            this.setServicePermitNumber(servicePermitNumber);
        }
        if (nameOfIssuingAuthority != null) {
            this.setNameOfIssuingAuthority(nameOfIssuingAuthority);
        }
        if (firstIssueServicePermit != null) {
            this.setFirstIssueServicePermit(firstIssueServicePermit);
        }
        if (servicePermitAttachment != null) {
            this.setServicePermitAttachment(servicePermitAttachment);
        }
        if (securityApprovalNumber != null) {
            this.setSecurityApprovalNumber(securityApprovalNumber);
        }
        if (CollectionUtils.isNotEmpty(serviceScopeList)) {
            this.setServiceScope(serviceScope);
            this.setServiceScopeDescription(serviceScopeDescription);
        }
        if (securityPreparednessRating != null) {
            this.setSecurityPreparednessRating(securityPreparednessRating);
        }
        if (securityArmedRating != null) {
            this.setSecurityArmedRating(securityArmedRating);
        }
        if (securitySafetyDefenseRating != null) {
            this.setSecuritySafetyDefenseRating(securitySafetyDefenseRating);
        }
        if (isRiskAssessment != null) {
            this.setIsRiskAssessment(isRiskAssessment);
        }
        if (trainContent != null) {
            this.setTrainContent(trainContent);
        }
        if (numberOfSecurityGuards != null) {
            this.setNumberOfSecurityGuards(numberOfSecurityGuards);
        }
        if (isPublicSecuritySecurity != null) {
            this.setIsPublicSecuritySecurity(isPublicSecuritySecurity);
        }
        if (isPropertyEnterprise != null) {
            this.setIsPropertyEnterprise(isPropertyEnterprise);
        }
        if (natureOfSelfRecruitedUnits != null) {
            this.setNatureOfSelfRecruitedUnits(natureOfSelfRecruitedUnits);
        }
        if (legalPersonName != null) {
            this.setLegalPersonName(legalPersonName);
        }
        if (legalPersonTelephone != null) {
            this.setLegalPersonTelephone(legalPersonTelephone);
        }
        if (legalPersonCredentialType != null) {
            this.setLegalPersonCredentialType(legalPersonCredentialType);
        }
        if (legalPersonCredentialNumber != null) {
            this.setLegalPersonCredentialNumber(legalPersonCredentialNumber);
        }
        if (legalPersonNationality != null) {
            this.setLegalPersonNationality(legalPersonNationality);
        }
        if (securityPersonName != null) {
            this.setSecurityPersonName(securityPersonName);
        }
        if (securityPersonTelephone != null) {
            this.setSecurityPersonTelephone(securityPersonTelephone);
        }
        if (securityPersonCredentialType != null) {
            this.setSecurityPersonCredentialType(securityPersonCredentialType);
        }
        if (securityPersonCredentialNumber != null) {
            this.setSecurityPersonCredentialNumber(securityPersonCredentialNumber);
        }
    }

    public static CompanyEntity create(OrganizationEntity organization) {
        CompanyEntity company = new CompanyEntity(organization);
        return company;
    }

    public static CompanyEntity create(OrganizationEntity organization, RegisterCompanyCommand command) {
        Integer serviceScope = null;
        String serviceScopeDescription = null;
        StringBuffer serviceScopeDescriptionSb = new StringBuffer();
        if (CollectionUtils.isNotEmpty(command.getServiceScopeList())) {
            int serviceScopeInt = 0;
            for (String scope : command.getServiceScopeList()) {
                int s = Integer.parseInt(scope);
                serviceScopeDescriptionSb.append(scope).append(";");
                serviceScopeInt = (int)((double)serviceScopeInt + Math.pow(2.0, s - 1));
            }
            serviceScope = serviceScopeInt;
            serviceScopeDescription = serviceScopeDescriptionSb.substring(0, serviceScopeDescriptionSb.length() - 1);
        }
        CompanyEntity company = new CompanyEntity(organization, command.getUnifySocialCreditCode(), command.getUnifySocialCreditCodeFile(), command.getParentName(), command.getParentCertificateType(), command.getParentCertificateNumber(), command.getParentLegalPersonName(), command.getParentLegalPersonTelephone(), command.getEconomicType(), command.getNature(), serviceScope, serviceScopeDescription, command.getRegisteredCapital(), command.getFixedCapital(), command.getAnnualProfitTax(), command.getAnnualSalesVolume(), command.getCertificateType(), command.getServicePermitNumber(), command.getSecurityApprovalNumber(), command.getNameOfIssuingAuthority(), command.getFirstIssueServicePermit(), command.getServicePermitAttachment(), command.getTrainContent(), command.getSecurityPreparednessRating(), command.getSecurityArmedRating(), command.getSecuritySafetyDefenseRating(), command.getIsRiskAssessment(), command.getNumberOfSecurityGuards(), command.getIsPublicSecuritySecurity(), command.getIsPropertyEnterprise(), command.getNatureOfSelfRecruitedUnits(), command.getLegalPersonName(), command.getLegalPersonTelephone(), command.getLegalPersonCredentialType(), command.getLegalPersonCredentialNumber(), command.getLegalPersonNationality(), command.getSecurityPersonName(), command.getSecurityPersonTelephone(), command.getSecurityPersonCredentialType(), command.getSecurityPersonCredentialNumber());
        return company;
    }

    public static CompanyEntity create(OrganizationEntity organization, CreateMyOrganizationCommand command) {
        Integer serviceScope = 0;
        String unifySocialCreditCode = command.getUnifySocialCreditCode();
        if (StringUtils.isEmpty((String)unifySocialCreditCode)) {
            unifySocialCreditCode = "#1";
        }
        CompanyEntity company = new CompanyEntity(organization, unifySocialCreditCode, command.getUnifySocialCreditCodeFile(), null, CompanyCertificateType.UniformCreditCode, "#1", "#1", "#1", EconomicType.Collective, CompanyNature.None, serviceScope, "#1", null, null, null, null, CompanyCertificateType.UniformCreditCode, null, null, null, null, null, null, SecurityPreparednessRating.None, SecurityArmedRating.None, SecuritySafetyDefenseRating.None, false, 0, false, false, "#1", "#1", "#1", CredentialType.IdCard, "#1", "#1", "#1", "#1", CredentialType.IdCard, "#1");
        return company;
    }

    public String getId() {
        return this.id;
    }

    public String getUnifySocialCreditCode() {
        return this.unifySocialCreditCode;
    }

    public String getUnifySocialCreditCodeFile() {
        return this.unifySocialCreditCodeFile;
    }

    public String getParentName() {
        return this.parentName;
    }

    public CompanyCertificateType getParentCertificateType() {
        return this.parentCertificateType;
    }

    public String getParentCertificateNumber() {
        return this.parentCertificateNumber;
    }

    public String getParentLegalPersonName() {
        return this.parentLegalPersonName;
    }

    public String getParentLegalPersonTelephone() {
        return this.parentLegalPersonTelephone;
    }

    public EconomicType getEconomicType() {
        return this.economicType;
    }

    public CompanyNature getNature() {
        return this.nature;
    }

    public Integer getServiceScope() {
        return this.serviceScope;
    }

    public String getServiceScopeDescription() {
        return this.serviceScopeDescription;
    }

    public String getRegisteredCapital() {
        return this.registeredCapital;
    }

    public String getFixedCapital() {
        return this.fixedCapital;
    }

    public String getAnnualProfitTax() {
        return this.annualProfitTax;
    }

    public String getAnnualSalesVolume() {
        return this.annualSalesVolume;
    }

    public CompanyCertificateType getCertificateType() {
        return this.certificateType;
    }

    public String getServicePermitNumber() {
        return this.servicePermitNumber;
    }

    public String getSecurityApprovalNumber() {
        return this.securityApprovalNumber;
    }

    public String getNameOfIssuingAuthority() {
        return this.nameOfIssuingAuthority;
    }

    public Date getFirstIssueServicePermit() {
        return this.firstIssueServicePermit;
    }

    public String getServicePermitAttachment() {
        return this.servicePermitAttachment;
    }

    public String getTrainContent() {
        return this.trainContent;
    }

    public SecurityPreparednessRating getSecurityPreparednessRating() {
        return this.securityPreparednessRating;
    }

    public SecurityArmedRating getSecurityArmedRating() {
        return this.securityArmedRating;
    }

    public SecuritySafetyDefenseRating getSecuritySafetyDefenseRating() {
        return this.securitySafetyDefenseRating;
    }

    public Boolean getIsRiskAssessment() {
        return this.isRiskAssessment;
    }

    public Integer getNumberOfSecurityGuards() {
        return this.numberOfSecurityGuards;
    }

    public Boolean getIsPublicSecuritySecurity() {
        return this.isPublicSecuritySecurity;
    }

    public Boolean getIsPropertyEnterprise() {
        return this.isPropertyEnterprise;
    }

    public String getNatureOfSelfRecruitedUnits() {
        return this.natureOfSelfRecruitedUnits;
    }

    public String getLegalPersonName() {
        return this.legalPersonName;
    }

    public String getLegalPersonTelephone() {
        return this.legalPersonTelephone;
    }

    public CredentialType getLegalPersonCredentialType() {
        return this.legalPersonCredentialType;
    }

    public String getLegalPersonCredentialNumber() {
        return this.legalPersonCredentialNumber;
    }

    public String getLegalPersonNationality() {
        return this.legalPersonNationality;
    }

    public String getSecurityPersonName() {
        return this.securityPersonName;
    }

    public String getSecurityPersonTelephone() {
        return this.securityPersonTelephone;
    }

    public CredentialType getSecurityPersonCredentialType() {
        return this.securityPersonCredentialType;
    }

    public String getSecurityPersonCredentialNumber() {
        return this.securityPersonCredentialNumber;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setUnifySocialCreditCode(String unifySocialCreditCode) {
        this.unifySocialCreditCode = unifySocialCreditCode;
    }

    protected void setUnifySocialCreditCodeFile(String unifySocialCreditCodeFile) {
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
    }

    protected void setParentName(String parentName) {
        this.parentName = parentName;
    }

    protected void setParentCertificateType(CompanyCertificateType parentCertificateType) {
        this.parentCertificateType = parentCertificateType;
    }

    protected void setParentCertificateNumber(String parentCertificateNumber) {
        this.parentCertificateNumber = parentCertificateNumber;
    }

    protected void setParentLegalPersonName(String parentLegalPersonName) {
        this.parentLegalPersonName = parentLegalPersonName;
    }

    protected void setParentLegalPersonTelephone(String parentLegalPersonTelephone) {
        this.parentLegalPersonTelephone = parentLegalPersonTelephone;
    }

    protected void setEconomicType(EconomicType economicType) {
        this.economicType = economicType;
    }

    protected void setNature(CompanyNature nature) {
        this.nature = nature;
    }

    protected void setServiceScope(Integer serviceScope) {
        this.serviceScope = serviceScope;
    }

    protected void setServiceScopeDescription(String serviceScopeDescription) {
        this.serviceScopeDescription = serviceScopeDescription;
    }

    protected void setRegisteredCapital(String registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    protected void setFixedCapital(String fixedCapital) {
        this.fixedCapital = fixedCapital;
    }

    protected void setAnnualProfitTax(String annualProfitTax) {
        this.annualProfitTax = annualProfitTax;
    }

    protected void setAnnualSalesVolume(String annualSalesVolume) {
        this.annualSalesVolume = annualSalesVolume;
    }

    protected void setCertificateType(CompanyCertificateType certificateType) {
        this.certificateType = certificateType;
    }

    protected void setServicePermitNumber(String servicePermitNumber) {
        this.servicePermitNumber = servicePermitNumber;
    }

    protected void setSecurityApprovalNumber(String securityApprovalNumber) {
        this.securityApprovalNumber = securityApprovalNumber;
    }

    protected void setNameOfIssuingAuthority(String nameOfIssuingAuthority) {
        this.nameOfIssuingAuthority = nameOfIssuingAuthority;
    }

    protected void setFirstIssueServicePermit(Date firstIssueServicePermit) {
        this.firstIssueServicePermit = firstIssueServicePermit;
    }

    protected void setServicePermitAttachment(String servicePermitAttachment) {
        this.servicePermitAttachment = servicePermitAttachment;
    }

    protected void setTrainContent(String trainContent) {
        this.trainContent = trainContent;
    }

    protected void setSecurityPreparednessRating(SecurityPreparednessRating securityPreparednessRating) {
        this.securityPreparednessRating = securityPreparednessRating;
    }

    protected void setSecurityArmedRating(SecurityArmedRating securityArmedRating) {
        this.securityArmedRating = securityArmedRating;
    }

    protected void setSecuritySafetyDefenseRating(SecuritySafetyDefenseRating securitySafetyDefenseRating) {
        this.securitySafetyDefenseRating = securitySafetyDefenseRating;
    }

    protected void setIsRiskAssessment(Boolean isRiskAssessment) {
        this.isRiskAssessment = isRiskAssessment;
    }

    protected void setNumberOfSecurityGuards(Integer numberOfSecurityGuards) {
        this.numberOfSecurityGuards = numberOfSecurityGuards;
    }

    protected void setIsPublicSecuritySecurity(Boolean isPublicSecuritySecurity) {
        this.isPublicSecuritySecurity = isPublicSecuritySecurity;
    }

    protected void setIsPropertyEnterprise(Boolean isPropertyEnterprise) {
        this.isPropertyEnterprise = isPropertyEnterprise;
    }

    protected void setNatureOfSelfRecruitedUnits(String natureOfSelfRecruitedUnits) {
        this.natureOfSelfRecruitedUnits = natureOfSelfRecruitedUnits;
    }

    protected void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    protected void setLegalPersonTelephone(String legalPersonTelephone) {
        this.legalPersonTelephone = legalPersonTelephone;
    }

    protected void setLegalPersonCredentialType(CredentialType legalPersonCredentialType) {
        this.legalPersonCredentialType = legalPersonCredentialType;
    }

    protected void setLegalPersonCredentialNumber(String legalPersonCredentialNumber) {
        this.legalPersonCredentialNumber = legalPersonCredentialNumber;
    }

    protected void setLegalPersonNationality(String legalPersonNationality) {
        this.legalPersonNationality = legalPersonNationality;
    }

    protected void setSecurityPersonName(String securityPersonName) {
        this.securityPersonName = securityPersonName;
    }

    protected void setSecurityPersonTelephone(String securityPersonTelephone) {
        this.securityPersonTelephone = securityPersonTelephone;
    }

    protected void setSecurityPersonCredentialType(CredentialType securityPersonCredentialType) {
        this.securityPersonCredentialType = securityPersonCredentialType;
    }

    protected void setSecurityPersonCredentialNumber(String securityPersonCredentialNumber) {
        this.securityPersonCredentialNumber = securityPersonCredentialNumber;
    }

    protected void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    protected void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }
}

