package com.bcxin.bus.apis.impls;

import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import com.bcxin.api.interfaces.buses.requests.MessageRequest;
import com.bcxin.bus.domains.components.MessageProvider;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class MessageRpcProviderImpl implements MessageRpcProvider {
    private final MessageProvider messageProvider;

    public MessageRpcProviderImpl(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    @Override
    public void dispatch(MessageRequest request) {
        if (request.getMessageType() != MessageType.SMS) {
            throw new NotSupportTenantException("不支持该协议");
        }

        this.messageProvider.execute(request.getParams());
    }
}
