/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.SM4;
import com.alibaba.fastjson.JSON;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.StringUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Base64Utils;

public class JwtCommonUtil {
    private static final String SIGN = "dragon";
    private static final String SIGNATURE_KEY = "!@#zhian12300zhang";
    private static final String TOKEN_SECRET = "SxhlwSecurityStaff";
    private static final String JWT_SECRET = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";
    private static final String SM4_KEY = "4h5o5t9weol6gmsr";
    private static final String IV = "RandomIV12345678";
    private static final int JWT_REFRESH_TTL = 604800000;

    private static SecretKey generalKey(String stringKey) {
        byte[] encodedKey = Base64.decodeBase64((String)stringKey);
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }

    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(new Date(System.currentTimeMillis())).setSubject(subject).signWith(signatureAlgorithm, (Key)JwtCommonUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String createJWT(Map<String, String> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtCommonUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String createJWT(Map<Object, Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtCommonUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims parseJWT(String jwttoken) {
        return (Claims)Jwts.parser().setSigningKey((Key)JwtCommonUtil.generalKey(JWT_SECRET)).parseClaimsJws(jwttoken).getBody();
    }

    public static String parseJWT1(String token) {
        return ((Claims)Jwts.parser().setSigningKey((Key)JwtCommonUtil.generalKey(JWT_SECRET)).parseClaimsJws(token).getBody()).getSubject();
    }

    public static String createJWT(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(subject).signWith(signatureAlgorithm, (Key)JwtCommonUtil.generalKey(JWT_SECRET));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static Boolean validationToken(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)SIGN);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT jwt = verifier.verify(token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static HashMap parseToken(String token) {
        Algorithm algorithm = null;
        try {
            algorithm = Algorithm.HMAC256((String)SIGN);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
        DecodedJWT jwt = verifier.verify(token);
        Map claims = jwt.getClaims();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("koalid", ((Claim)claims.get("koalid")).asString());
        result.put("name", ((Claim)claims.get("name")).asString());
        result.put("sfz", ((Claim)claims.get("sfz")).asString());
        result.put("org", ((Claim)claims.get("org")).asString());
        result.put("orgName", ((Claim)claims.get("orgName")).asString());
        return result;
    }

    public static String decryptSm4Token(String token) {
        if (StringUtils.isEmpty(token)) {
            return "";
        }
        try {
            SM4 sm4 = new SM4(Mode.CBC, Padding.PKCS5Padding, SM4_KEY.getBytes(CharsetUtil.CHARSET_UTF_8), IV.getBytes(CharsetUtil.CHARSET_UTF_8));
            byte[] cipherHex = cn.hutool.core.codec.Base64.decode((CharSequence)token.trim());
            return sm4.decryptStr(cipherHex, CharsetUtil.CHARSET_UTF_8);
        }
        catch (Exception e) {
            throw new BadTenantException("token\u65e0\u6cd5\u8bc6\u522b\uff1a" + e.getMessage());
        }
    }

    public static String BJZZ_createToken(Map<String, String> verifyInfoMap) {
        Algorithm SIGNATURE_ALGORITHM = null;
        try {
            SIGNATURE_ALGORITHM = Algorithm.HMAC256((String)SIGNATURE_KEY);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alg", "HS256");
        map.put("typ", "JWT");
        String token = JWT.create().withHeader(map).withExpiresAt(new Date(System.currentTimeMillis() + 1296000000L)).withClaim("idNo", verifyInfoMap.get("idNo")).withClaim("name", verifyInfoMap.get("name")).withClaim("ukeySn", verifyInfoMap.get("ukeySn")).withClaim("organCode", verifyInfoMap.get("organCode")).withClaim("organName", verifyInfoMap.get("organName")).withClaim("orgLevel", verifyInfoMap.get("orgLevel")).withClaim("roleCode", verifyInfoMap.get("roleCode")).withClaim("thirdLevelOrgCode", verifyInfoMap.get("thirdLevelOrgCode")).withClaim("secondLevelOrgCode", verifyInfoMap.get("secondLevelOrgCode")).sign(SIGNATURE_ALGORITHM);
        token = Base64Utils.encodeToString((byte[])token.getBytes(StandardCharsets.UTF_8));
        return token;
    }

    public static Map<String, String> BJZZ_verifyToken(String token) throws UnsupportedEncodingException {
        token = new String(Base64Utils.decodeFromString((String)token), "utf-8");
        try {
            Algorithm SIGNATURE_ALGORITHM = Algorithm.HMAC256((String)SIGNATURE_KEY);
            JWTVerifier verifier = JWT.require((Algorithm)SIGNATURE_ALGORITHM).build();
            DecodedJWT jwt = verifier.verify(token);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("idNo", jwt.getClaim("idNo").asString());
            result.put("name", jwt.getClaim("name").asString());
            result.put("ukeySn", jwt.getClaim("ukeySn").asString());
            result.put("organCode", jwt.getClaim("organCode").asString());
            result.put("organName", jwt.getClaim("organName").asString());
            result.put("orglevel", jwt.getClaim("orglevel").asString());
            return result;
        }
        catch (Exception e) {
            throw new BadTenantException("token\u65e0\u6cd5\u8bc6\u522b\uff1a" + e.getMessage());
        }
    }

    public static Map<String, String> SXZW_verifyToken(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)TOKEN_SECRET);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT Jwts2 = verifier.verify(token);
            HashMap<String, String> result = new HashMap<String, String>();
            String type = Jwts2.getClaim("TYPE").asString();
            result.put("TYPE", type);
            if ("0".equals(type)) {
                result.put("MOBILE", Jwts2.getClaim("MOBILE") != null ? Jwts2.getClaim("MOBILE").asString() : "");
                result.put("PERSON", Jwts2.getClaim("PERSON") != null ? Jwts2.getClaim("PERSON").asString() : "");
                result.put("PERSONID", Jwts2.getClaim("PERSONID") != null ? Jwts2.getClaim("PERSONID").asString() : "");
            } else {
                result.put("BLRMOBILE", Jwts2.getClaim("BLRMOBILE") != null ? Jwts2.getClaim("BLRMOBILE").asString() : "");
                result.put("LEGALPERSONID", Jwts2.getClaim("LEGALPERSONID") != null ? Jwts2.getClaim("LEGALPERSONID").asString() : "");
                result.put("LEGALPERSON", Jwts2.getClaim("LEGALPERSON") != null ? Jwts2.getClaim("LEGALPERSON").asString() : "");
                result.put("LEGALPERSONPHONE", Jwts2.getClaim("LEGALPERSONPHONE") != null ? Jwts2.getClaim("LEGALPERSONPHONE").asString() : "");
            }
            return result;
        }
        catch (Exception e) {
            throw new BadTenantException("token\u65e0\u6cd5\u8bc6\u522b\uff1a" + e.getMessage());
        }
    }

    public static String SXZW_createToken(Map<String, String> verifyInfoMap) {
        Algorithm SIGNATURE_ALGORITHM = null;
        try {
            SIGNATURE_ALGORITHM = Algorithm.HMAC256((String)TOKEN_SECRET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alg", "HS256");
        map.put("typ", "JWT");
        String token = verifyInfoMap.get("TYPE").equals("0") ? JWT.create().withHeader(map).withExpiresAt(new Date(System.currentTimeMillis() + 1296000000L)).withClaim("MOBILE", verifyInfoMap.get("MOBILE")).withClaim("PERSON", verifyInfoMap.get("PERSON")).withClaim("PERSONID", verifyInfoMap.get("PERSONID")).withClaim("TYPE", verifyInfoMap.get("TYPE")).sign(SIGNATURE_ALGORITHM) : JWT.create().withHeader(map).withExpiresAt(new Date(System.currentTimeMillis() + 1296000000L)).withClaim("TYPE", verifyInfoMap.get("TYPE")).withClaim("BLRMOBILE", verifyInfoMap.get("BLRMOBILE")).withClaim("LEGALPERSONID", verifyInfoMap.get("LEGALPERSONID")).withClaim("LEGALPERSON", verifyInfoMap.get("LEGALPERSON")).withClaim("LEGALPERSONPHONE", verifyInfoMap.get("LEGALPERSONPHONE")).sign(SIGNATURE_ALGORITHM);
        return token;
    }
}

