/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.components.models.CacheItemAbstract;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

public interface CacheProvider {
    public <T extends CacheItemAbstract> T get(String var1, Supplier<T> var2);

    public <T extends CacheItemAbstract> void put(String var1, T var2);

    public void delete(String var1);

    @Component
    public static class DefaultCacheProviderImpl
    implements CacheProvider {
        private static final Logger log = LoggerFactory.getLogger(DefaultCacheProviderImpl.class);
        private static Map<String, CacheItemAbstract> _localCachedContainer = new ConcurrentHashMap<String, CacheItemAbstract>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends CacheItemAbstract> T get(String key, Supplier<T> supplier) {
            CacheItemAbstract data = null;
            try {
                data = _localCachedContainer.get(key);
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u7f13\u5b58({})\u6570\u636e\u53d1\u9001\u5f02\u5e38:{}", (Object)key, (Object)ExceptionUtil.getStackMessage(ex));
            }
            finally {
                if (data == null || data.isExpired()) {
                    data = (CacheItemAbstract)supplier.get();
                    _localCachedContainer.put(key, data);
                }
            }
            return (T)data;
        }

        @Override
        public <T extends CacheItemAbstract> void put(String key, T data) {
            _localCachedContainer.put(key, data);
        }

        @Override
        public void delete(String key) {
            _localCachedContainer.remove(key);
        }
    }
}

