package com.bcxin.security.domains.dtos;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ColumnWidth(20)
public class CertificateExportDto implements Serializable {

    private static final long serialVersionUID = 4510474987109938206L;

    @ExcelProperty("姓名")
    @ColumnWidth(10)
    private String name;

    @ExcelProperty("身份证号")
    private String idNum;

    /**
     * 证书编号
     */
    @ExcelProperty({"保安资格证", "证书编号"})
    @ColumnWidth(15)
    private String cerNo;
    /**
     * 发证机关
     */
    @ExcelProperty({"保安资格证", "发证机关"})
    private String cerFrom;
    /**
     * 发证日期
     */
    @ExcelProperty({"保安资格证", "发证日期"})
    @DateTimeFormat("yyyy年MM月dd日")
    private Date cerDate;
    /**
     * 状态
     */
    @ExcelProperty({"保安资格证", "状态"})
    @ColumnWidth(8)
    private String status;

    /**
     * 证书编号
     */
    @ExcelProperty({"保安五级等级证", "证书编号"})
    @ColumnWidth(15)
    private String grade5CerNo;
    /**
     * 发证机关
     */
    @ExcelProperty({"保安五级等级证", "发证机关"})
    private String grade5CerFrom;
    /**
     * 发证日期
     */
    @ExcelProperty({"保安五级等级证", "发证日期"})
    @DateTimeFormat("yyyy年MM月dd日")
    private Date grade5CerDate;
    /**
     * 状态
     */
    @ExcelProperty({"保安五级等级证", "状态"})
    @ColumnWidth(8)
    private String grade5Status;

    /**
     * 证书编号
     */
    @ExcelProperty({"保安四级等级证", "证书编号"})
    @ColumnWidth(15)
    private String grade4CerNo;
    /**
     * 发证机关
     */
    @ExcelProperty({"保安四级等级证", "发证机关"})
    private String grade4CerFrom;
    /**
     * 发证日期
     */
    @ExcelProperty({"保安四级等级证", "发证日期"})
    @DateTimeFormat("yyyy年MM月dd日")
    private Date grade4CerDate;
    /**
     * 状态
     */
    @ExcelProperty({"保安四级等级证", "状态"})
    @ColumnWidth(8)
    private String grade4Status;

    public CertificateExportDto(){
    }

    public CertificateExportDto(String name,String idNum){
        this.name = name;
        this.idNum = idNum;
    }

    public static CertificateExportDto create(String name,String idNum) {
        return new CertificateExportDto(name,idNum);
    }
}
