/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.entities.PrincipalAbstract;
import com.bcxin.identity.domains.enums.PrincipalStatus;
import com.bcxin.identity.domains.events.IdentityUser_WechatBindEvent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="identity_wechat")
public class WechatPrincipalEntity
extends PrincipalAbstract
implements IAggregate {
    @Column(name="openId", nullable=false, length=200)
    private String openId;
    @Column(name="nicky", nullable=true, length=50)
    private String nicky;
    @Column(name="union_id")
    private String unionId;

    protected WechatPrincipalEntity() {
    }

    public static WechatPrincipalEntity create(IdentityUserEntity identityUser, String openId, String nicky, String unionId) {
        return WechatPrincipalEntity.create(identityUser, UUIDUtil.getShortUuid(), openId, nicky, unionId);
    }

    public static WechatPrincipalEntity create(IdentityUserEntity identityUser, String id, String openId, String nicky, String unionId) {
        WechatPrincipalEntity principal = new WechatPrincipalEntity();
        principal.setId(UUIDUtil.getShortUuid());
        principal.setIdentityUser(identityUser);
        principal.setOpenId(openId);
        principal.setNicky(nicky);
        principal.setUnionId(unionId);
        principal.setStatus(PrincipalStatus.ACTIVATE);
        principal.recordEvent(IdentityUser_WechatBindEvent.create(identityUser.getTenantUserId(), principal.getOpenId(), principal.getNicky()));
        return principal;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getNicky() {
        return this.nicky;
    }

    public String getUnionId() {
        return this.unionId;
    }

    protected void setOpenId(String openId) {
        this.openId = openId;
    }

    protected void setNicky(String nicky) {
        this.nicky = nicky;
    }

    protected void setUnionId(String unionId) {
        this.unionId = unionId;
    }
}

