package com.bcxin.identity.domains.entities;

import com.bcxin.Infrastructures.SystemConstant;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.identity.domains.enums.COAuthType;
import com.bcxin.identity.domains.enums.PrincipalStatus;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;


/**
 * 仅用于做c端的用户认证
 */
@Table(name = "identity_toc_oauth_subjects")
@Entity
@Getter
@Setter(AccessLevel.PROTECTED)
public class ToCOAuthSubjectPrincipalEntity extends EntityAbstract implements IAggregate {

    @Column(name = "co_auth_type",nullable = false)
    @Enumerated(EnumType.ORDINAL)
    private COAuthType coAuthType;

    @Id
    @Column(name = "id", length = 100)
    private String id;

    /**
     * 针对小程序登入;该值为小程序的unionId
     * 小程序的openId最大长度为28个字符，unionId最大长度为293个字符
     */
    @Column(name = "union_id", length = 300, nullable = false)
    private String unionId;

    /**
     * 针对小程序登入;该值为小程序的open_id
     */
    @Column(name = "open_id", length = 100, nullable = false)
    private String openId;

    /**
     * 系统编码
     */
    @Column(name = "sys_code", length = 30, nullable = false)
    private String sysCode;

    /**
     * 昵称信息
     */
    @Column(name = "nicky",length = 50)
    private String nicky;

    /**
     * 认证内容
     */
    @Column(name = "content",length = 500)
    private String content;

    @Column(name = "status",nullable = false)
    @Enumerated(EnumType.ORDINAL)
    private PrincipalStatus status;

    /**
     * 针对C端用户; 刚开始, 我们不创建用户信息
     * 认证之后才创建用户信息
     */
    @Column(name = "identity_user_id", length = 100)
    private String identityUserId;

    /**
     * 冗余: 智能人事的人员Id
     */
    @Column(name = "tenant_user_id", length = 100)
    private String tenantUserId;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    @Column(name = "assigned_time", nullable = false)
    private Timestamp assignedTime;

    public ToCOAuthSubjectPrincipalEntity() {
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static ToCOAuthSubjectPrincipalEntity create(
                                                 COAuthType coAuthType,
                                                 String id,
                                                 String openId,
                                                 String unionId,
                                                 String nicky,
                                                 String sysCode,
                                                 IdentityUserEntity identityUser) {
        ToCOAuthSubjectPrincipalEntity tocOAuthSubject = new ToCOAuthSubjectPrincipalEntity();
        tocOAuthSubject.setId(id);
        tocOAuthSubject.setId(openId);
        tocOAuthSubject.setCoAuthType(coAuthType);
        tocOAuthSubject.setOpenId(openId);
        tocOAuthSubject.setUnionId(unionId);
        tocOAuthSubject.setSysCode(sysCode);
        tocOAuthSubject.setNicky(nicky);

        tocOAuthSubject.setStatus(PrincipalStatus.ACTIVATE);
        tocOAuthSubject.setCoAuthType(COAuthType.WechatCgi);

        if (identityUser != null) {
            tocOAuthSubject.setIdentityUserId(identityUser.getId());
            tocOAuthSubject.setTenantUserId(identityUser.getTenantUserId());
        }else{
            tocOAuthSubject.setIdentityUserId(SystemConstant.EmptyValue);
            tocOAuthSubject.setTenantUserId(SystemConstant.EmptyValue);
        }

        return tocOAuthSubject;
    }

    public void assignAssign(String tenantUserId,String identityUserId) {
        this.setTenantUserId(tenantUserId);
        this.setIdentityUserId(identityUserId);
        this.setAssignedTime(Timestamp.from(Instant.now()));
    }
}
