/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.enums.COAuthType;
import com.bcxin.identity.domains.enums.PrincipalStatus;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="identity_toc_oauth_subjects")
@Entity
public class ToCOAuthSubjectPrincipalEntity
extends EntityAbstract
implements IAggregate {
    @Column(name="co_auth_type", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private COAuthType coAuthType;
    @Id
    @Column(name="id", length=100)
    private String id;
    @Column(name="union_id", length=300, nullable=false)
    private String unionId;
    @Column(name="open_id", length=100, nullable=false)
    private String openId;
    @Column(name="sys_code", length=30, nullable=false)
    private String sysCode;
    @Column(name="nicky", length=50)
    private String nicky;
    @Column(name="content", length=500)
    private String content;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private PrincipalStatus status;
    @Column(name="identity_user_id", length=100)
    private String identityUserId;
    @Column(name="tenant_user_id", length=100)
    private String tenantUserId;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime = Timestamp.from(Instant.now());
    @Column(name="assigned_time", nullable=false)
    private Timestamp assignedTime;

    public static ToCOAuthSubjectPrincipalEntity create(COAuthType coAuthType, String id, String openId, String unionId, String nicky, String sysCode, IdentityUserEntity identityUser) {
        ToCOAuthSubjectPrincipalEntity tocOAuthSubject = new ToCOAuthSubjectPrincipalEntity();
        tocOAuthSubject.setId(id);
        tocOAuthSubject.setId(openId);
        tocOAuthSubject.setCoAuthType(coAuthType);
        tocOAuthSubject.setOpenId(openId);
        tocOAuthSubject.setUnionId(unionId);
        tocOAuthSubject.setSysCode(sysCode);
        tocOAuthSubject.setNicky(nicky);
        tocOAuthSubject.setStatus(PrincipalStatus.ACTIVATE);
        tocOAuthSubject.setCoAuthType(COAuthType.WechatCgi);
        if (identityUser != null) {
            tocOAuthSubject.setIdentityUserId(identityUser.getId());
            tocOAuthSubject.setTenantUserId(identityUser.getTenantUserId());
        } else {
            tocOAuthSubject.setIdentityUserId("#1");
            tocOAuthSubject.setTenantUserId("#1");
        }
        return tocOAuthSubject;
    }

    public void assignAssign(String tenantUserId, String identityUserId) {
        this.setTenantUserId(tenantUserId);
        this.setIdentityUserId(identityUserId);
        this.setAssignedTime(Timestamp.from(Instant.now()));
    }

    public COAuthType getCoAuthType() {
        return this.coAuthType;
    }

    public String getId() {
        return this.id;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getSysCode() {
        return this.sysCode;
    }

    public String getNicky() {
        return this.nicky;
    }

    public String getContent() {
        return this.content;
    }

    public PrincipalStatus getStatus() {
        return this.status;
    }

    public String getIdentityUserId() {
        return this.identityUserId;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getAssignedTime() {
        return this.assignedTime;
    }

    protected void setCoAuthType(COAuthType coAuthType) {
        this.coAuthType = coAuthType;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    protected void setOpenId(String openId) {
        this.openId = openId;
    }

    protected void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    protected void setNicky(String nicky) {
        this.nicky = nicky;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    protected void setStatus(PrincipalStatus status) {
        this.status = status;
    }

    protected void setIdentityUserId(String identityUserId) {
        this.identityUserId = identityUserId;
    }

    protected void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setAssignedTime(Timestamp assignedTime) {
        this.assignedTime = assignedTime;
    }
}

