/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.entities.PrincipalAbstract;
import com.bcxin.identity.domains.enums.EventAction;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="identity_user_events")
public class IdentityUserEventEntity
extends EntityAbstract {
    @Id
    private String id;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Enumerated(value=EnumType.ORDINAL)
    private EventAction action;
    @Column(name="content", length=4000)
    private String content;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="identity_user_id", referencedColumnName="id", nullable=false)
    private IdentityUserEntity identityUser;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="principal_id", referencedColumnName="id", nullable=true)
    private PrincipalAbstract principal;

    protected IdentityUserEventEntity() {
    }

    public static IdentityUserEventEntity create(EventAction eventAction, String content, IdentityUserEntity identityUser, PrincipalAbstract principal) {
        IdentityUserEventEntity identityUserEvent = new IdentityUserEventEntity();
        identityUserEvent.setId(UUID.randomUUID().toString());
        identityUserEvent.setCreatedTime(Timestamp.from(Instant.now()));
        identityUserEvent.setAction(eventAction);
        identityUserEvent.setContent(content);
        identityUserEvent.setIdentityUser(identityUser);
        identityUserEvent.setPrincipal(principal);
        return identityUserEvent;
    }

    public String getId() {
        return this.id;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public EventAction getAction() {
        return this.action;
    }

    public String getContent() {
        return this.content;
    }

    public IdentityUserEntity getIdentityUser() {
        return this.identityUser;
    }

    public PrincipalAbstract getPrincipal() {
        return this.principal;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setAction(EventAction action) {
        this.action = action;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    protected void setIdentityUser(IdentityUserEntity identityUser) {
        this.identityUser = identityUser;
    }

    protected void setPrincipal(PrincipalAbstract principal) {
        this.principal = principal;
    }
}

