/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.wrappers;

import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageTableMappingDataSnapshot;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DoActionType;
import com.bcxin.tenant.bcx.infrastructures.enums.DynamicMappingType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DynamicDataWrapper
implements Serializable {
    private DynamicMappingType mappingType;
    private DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot dsl;
    private DoActionType actionType;
    private Map<String, Object> params = new HashMap<String, Object>();
    private int pageIndex = 1;
    private int pageSize = 10;
    private boolean ignorePage = false;
    private String actionDsl;
    private String queryCondition;
    private TenantEmployeeContext.TenantUserModel currentUser;

    public String getFullQueryConditionDsl() {
        String CONDITION_PLACE_HOLDER = "[[CONDITION_PLACE_HOLDER]]";
        if (this.dsl.getQueryDsl().contains("[[CONDITION_PLACE_HOLDER]]")) {
            return this.dsl.getQueryDsl().replace("[[CONDITION_PLACE_HOLDER]]", this.getQueryCondition());
        }
        return String.format("%s %s", this.dsl.getQueryDsl(), this.getQueryCondition());
    }

    public DynamicDataWrapper() {
        this.getParams().put("domain_id", "#1");
        this.getParams().put("creator_id", "#1");
        this.getParams().put("last_updater_id", "#1");
        Timestamp now = Timestamp.from(Instant.now());
        this.getParams().put("created_time", now);
        this.getParams().put("created_time", now);
    }

    public static DynamicDataWrapper create(DynamicPageTableMappingDataSnapshot tableMapping, DynamicPageDataEntity entity, JsonProvider jsonProvider, DoActionType actionType) {
        if (entity == null) {
            throw new ArgumentTenantException("\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38");
        }
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        tableMapping.buildAndFillWrapper(wrapper, entity, jsonProvider);
        wrapper.setActionType(actionType);
        wrapper.setActionDsl(tableMapping.getActionDsl(actionType));
        return wrapper;
    }

    public static DynamicDataWrapper createForGetAndDeleteAction(DynamicPageTableMappingDataSnapshot tableMapping, String pageId, String id) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        wrapper.getParams().put("pageId", pageId);
        wrapper.getParams().put("id", id);
        return wrapper;
    }

    public static DynamicDataWrapper createForSearch(DynamicPageTableMappingDataSnapshot tableMapping, Map<String, Object> params, boolean ignorePage, int pageIndex, int pageSize) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setIgnorePage(ignorePage);
        wrapper.setPageIndex(pageIndex);
        wrapper.setPageSize(pageSize);
        wrapper.setMappingType(tableMapping.getMappingType());
        StringBuilder sb = new StringBuilder();
        if (params != null && !CollectionUtils.isEmpty(params)) {
            for (String key : params.keySet()) {
                if ("pageId".equals(key)) {
                    wrapper.addParam(key, params.get(key));
                    continue;
                }
                Object value = params.get(key);
                String paramKey = key.replace(".", "_");
                wrapper.addParam(paramKey, params.get(key));
                if (value == null) continue;
                if (value instanceof String) {
                    if (!StringUtils.hasLength((String)((String)value))) continue;
                    sb.append(" and ").append(key).append(" like ").append("concat('%', #{params." + paramKey + "}, '%') ");
                    continue;
                }
                if (value instanceof List) {
                    List valueCollection = (List)value;
                    if (key.contains("time")) {
                        Object beginValue = valueCollection.get(0);
                        Object endValue = valueCollection.get(1);
                        if (beginValue != null) {
                            String beginKey = String.format("%s_From", paramKey);
                            wrapper.addParam(beginKey, beginValue);
                            sb.append(" and ").append(key).append(" >= ").append("#{params." + beginKey + "}");
                        }
                        if (endValue == null) continue;
                        String endKey = String.format("%s_To", paramKey);
                        wrapper.addParam(endKey, endValue);
                        sb.append(" and ").append(key).append(" <= ").append("#{params." + endKey + "}");
                        continue;
                    }
                    StringBuilder sbCondition = new StringBuilder();
                    for (int index = 0; index < valueCollection.size(); ++index) {
                        String itemKey = String.format("%s_%s", paramKey, index);
                        if (sbCondition.length() > 0) {
                            sbCondition.append(",");
                        }
                        sbCondition.append("#{params." + itemKey + "}");
                        wrapper.addParam(itemKey, valueCollection.get(index));
                    }
                    sb.append(" and ").append(key).append(" in ").append("(" + sbCondition + ")");
                    continue;
                }
                sb.append(" and ").append(key).append(" = ").append("#{params." + paramKey + "}");
            }
        }
        wrapper.setQueryCondition(sb.toString());
        return wrapper;
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

    public void addParams(Map<String, Object> params) {
        this.params.putAll(params);
    }

    public void assignCurrentUser(TenantEmployeeContext.TenantUserModel user) {
        this.currentUser = user;
    }

    public DynamicMappingType getMappingType() {
        return this.mappingType;
    }

    public DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot getDsl() {
        return this.dsl;
    }

    public DoActionType getActionType() {
        return this.actionType;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isIgnorePage() {
        return this.ignorePage;
    }

    public String getActionDsl() {
        return this.actionDsl;
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public TenantEmployeeContext.TenantUserModel getCurrentUser() {
        return this.currentUser;
    }

    protected void setMappingType(DynamicMappingType mappingType) {
        this.mappingType = mappingType;
    }

    protected void setDsl(DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot dsl) {
        this.dsl = dsl;
    }

    protected void setActionType(DoActionType actionType) {
        this.actionType = actionType;
    }

    protected void setParams(Map<String, Object> params) {
        this.params = params;
    }

    protected void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    protected void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void setIgnorePage(boolean ignorePage) {
        this.ignorePage = ignorePage;
    }

    protected void setActionDsl(String actionDsl) {
        this.actionDsl = actionDsl;
    }

    protected void setQueryCondition(String queryCondition) {
        this.queryCondition = queryCondition;
    }

    protected void setCurrentUser(TenantEmployeeContext.TenantUserModel currentUser) {
        this.currentUser = currentUser;
    }
}

