/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.services.impls;

import com.bcxin.tenant.bcx.domains.entities.MetaModuleEntity;
import com.bcxin.tenant.bcx.domains.repositories.MetaModuleRepository;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaModuleSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.MetaModuleService;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.BatchLogicalDeleteModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.CreateMetaModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.LogicalDeleteModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.UpdateMetaModuleCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.UnitWork;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MetaModuleServiceImpl
implements MetaModuleService {
    private final MetaModuleRepository metaModuleRepository;
    private final UnitWork unitWork;
    private final IdWorker idWorker;

    public MetaModuleServiceImpl(MetaModuleRepository metaModuleRepository, UnitWork unitWork, IdWorker idWorker) {
        this.metaModuleRepository = metaModuleRepository;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateMetaModuleCommand command) {
        command.validate();
        if (StringUtil.isEmpty((String)command.getName())) {
            throw new IllegalArgumentException("\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        this.unitWork.executeTran(() -> {
            String id = String.valueOf(this.idWorker.getNextId());
            MetaModuleEntity entity = MetaModuleEntity.create(id, command.getProjectId(), command.getName(), userModel.getUserType(), userModel.getOrganizationId(), userModel.getId());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            entity.setCreatedTime(now);
            entity.setLastUpdatedTime(now);
            this.metaModuleRepository.insert(entity);
        });
    }

    @Override
    public void dispatch(UpdateMetaModuleCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaModuleEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
            entity.change(command.getName(), userModel);
            this.metaModuleRepository.update(entity);
        });
    }

    @Override
    public void dispatch(DeleteDataCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaModuleEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            this.metaModuleRepository.delete(command.getId());
        });
    }

    @Override
    public void dispatch(LogicalDeleteModuleCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            MetaModuleEntity entity = this.getByIdIncludeDeleted(command.getId());
            if (entity == null) {
                throw new NoFoundTenantException();
            }
            if (entity.isDeleted()) {
                throw new NoFoundTenantException();
            }
            TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
            entity.changeMarkAsDeleted(userModel);
            this.metaModuleRepository.update(entity);
        });
    }

    @Override
    public void dispatch(BatchLogicalDeleteModuleCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> {
            List<String> ids = command.getIds();
            if (ids == null || ids.isEmpty()) {
                return;
            }
            List<MetaModuleEntity> entities = this.metaModuleRepository.getByIds(ids);
            ArrayList<String> validIds = new ArrayList<String>();
            for (MetaModuleEntity entity : entities) {
                if (entity == null || entity.isDeleted()) continue;
                validIds.add(entity.getId());
            }
            if (validIds.isEmpty()) {
                return;
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            this.metaModuleRepository.batchMarkAsDeleted(validIds, now);
        });
    }

    @Override
    public EntityCollection<MetaModuleEntity> search(MetaModuleSearchCriteria criteria) {
        return this.metaModuleRepository.search(criteria);
    }

    @Override
    public MetaModuleEntity getById(String id) {
        MetaModuleEntity entity = (MetaModuleEntity)this.metaModuleRepository.getById(id);
        if (entity != null && entity.isDeleted()) {
            return null;
        }
        return entity;
    }

    private MetaModuleEntity getByIdIncludeDeleted(String id) {
        return (MetaModuleEntity)this.metaModuleRepository.getById(id);
    }
}

