package com.bcxin.tenant.bcx.domains.services.commands.pages;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Getter;

import java.sql.Timestamp;
import java.util.Date;

/**
 * 更新页面元数据命令
 */
@Getter
public class UpdateMetaPageCommand extends CommandAbstract {
    private final String id;
    private final String name;
    private final String note;
    private final String slug;
    private final String logo;
    private final PageType pageType;
    private final PageBusinessType businessType;
    private final String tableName;
    private final Boolean enableBPMFlow;
    private final Boolean enableAnonymousAccess;
    private final boolean sync2Identity;

    private final Timestamp beginTime;

    private final Timestamp endTime;

    private final String attachment;

    private final int limitedCount;


    public UpdateMetaPageCommand(String id, String name, String note,
                                 String slug, String logo, PageType pageType,
                                 PageBusinessType businessType, String tableName,
                                 Boolean enableBPMFlow, Boolean enableAnonymousAccess,
                                 boolean sync2Identity,Timestamp beginTime,Timestamp endTime,
                                 String attachment,int limitedCount) {
        this.id = id;
        this.name = name;
        this.note = note;
        this.slug = slug;
        this.logo = logo;
        this.pageType = pageType;
        this.businessType = businessType;
        this.tableName = tableName;
        this.enableBPMFlow = enableBPMFlow;
        this.enableAnonymousAccess = enableAnonymousAccess;
        this.sync2Identity = sync2Identity;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.attachment = attachment;
        this.limitedCount = limitedCount;
    }

    public static UpdateMetaPageCommand create(String id, String name, String note,
                                               String slug, String logo, PageType pageType,
                                               PageBusinessType businessType, String tableName, boolean enableBPMFlow,
                                               boolean enableAnonymousAccess,
                                               boolean sync2Identity,Timestamp beginTime,Timestamp endTime,
                                               String attachment,int limitedCount) {
        return new UpdateMetaPageCommand(
                id, name, note, slug, logo, pageType, businessType, tableName, enableBPMFlow,
                enableAnonymousAccess,
                sync2Identity,beginTime,endTime,attachment,limitedCount);
    }
}

