package com.bcxin.tenant.bcx.domains.services.commands.dynamics;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Getter
public class BatchDynamicPageDataCommand extends CommandAbstract {
    private final String pageId;
    private final Collection<Map<String, Object>> items;

    public BatchDynamicPageDataCommand(String pageId, Collection<Map<String, Object>> items) {
        this.pageId = pageId;
        this.items = items;
    }

    public static BatchDynamicPageDataCommand create(String pageId, Collection<Map<String, Object>> items) {
        return new BatchDynamicPageDataCommand(pageId, items);
    }
}
