package com.bcxin.tenant.bcx.domains.repositories.criterias;

import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Getter;

import java.util.List;

@Getter
public class MetaPageSearchCriteria {
    private final String id;
    private final List<String> ids;
    private final String projectId;
    private final String moduleId;
    private final String name;
    private final String slug;
    private final PageType pageType;
    private final List<PageType> pageTypes;
    private final PageBusinessType businessType;
    private final List<PageBusinessType> businessTypes;
    private final String tableName;
    private final Boolean enableBPMFlow;
    private final int pageIndex;
    private final int pageSize;

    private MetaPageSearchCriteria(String id, List<String> ids, String projectId, String moduleId,
                                   String name, String slug, PageType pageType, List<PageType> pageTypes,
                                   PageBusinessType businessType, List<PageBusinessType> businessTypes,
                                   String tableName, Boolean enableBPMFlow, int pageIndex, int pageSize) {
        this.id = id;
        this.ids = ids;
        this.projectId = projectId;
        this.moduleId = moduleId;
        this.name = name;
        this.slug = slug;
        this.pageType = pageType;
        this.pageTypes = pageTypes;
        this.businessType = businessType;
        this.businessTypes = businessTypes;
        this.tableName = tableName;
        this.enableBPMFlow = enableBPMFlow;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public static MetaPageSearchCriteria create(String id, List<String> ids, String projectId, String moduleId,
                                                String name, String slug, PageType pageType, List<PageType> pageTypes,
                                                PageBusinessType businessType, List<PageBusinessType> businessTypes,
                                                String tableName, Boolean enableBPMFlow, int pageIndex, int pageSize) {
        return new MetaPageSearchCriteria(id, ids, projectId, moduleId, name, slug, pageType, pageTypes,
                                         businessType, businessTypes, tableName, enableBPMFlow, pageIndex, pageSize);
    }
}

