package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Data;

import java.sql.Timestamp;

/**
 * meta_page_versions的内容包含meta_pages的version和form_json内容
 */
@Data
@TableName(value = "meta_page_versions",autoResultMap = true)
public class MetaPageVersionEntity extends EntityAbstract implements Aggregate {

    @TableId(value = "id")
    private String id;

    /**
     * 版本号; 有提交对应的业务数据之后; 自动增加版本号
     */
    @TableField(value = "version")
    private long version;

    /**
     * 表单结构类型
     */
    @TableField(value = "form_json")
    private String formJson;

    /**
     * 表单设置结构类型
     */
    @TableField(value = "form_setting_json")
    private String formSettingJson;

    /**
     * 所属页面Id
     */
    @TableField(value = "page_id")
    private String pageId;

    @TableField(value = "created_time")
    private Timestamp createdTime;
    
    /**
     * 静态工厂方法，用于创建页面版本实体
     */
    public static MetaPageVersionEntity create(String id, String pageId, long version, 
                                              String formJson, String formSettingJson, Timestamp createdTime) {
        MetaPageVersionEntity entity = new MetaPageVersionEntity();
        entity.id = id;
        entity.pageId = pageId;
        entity.version = version;
        entity.formJson = formJson;
        entity.formSettingJson = formSettingJson;
        entity.createdTime = createdTime;
        return entity;
    }
}