/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.document.domains.documents;

import com.bcxin.tenant.bcx.document.domains.documents.messages.MessageContentDocumentAbstract;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import org.springframework.data.annotation.Id;

@Document(language=SearchLanguage.CHINESE, timeToLive=300L)
public class NotifyMessageDocument
extends EntityAbstract {
    @Id
    @Indexed
    private String id;
    @Indexed
    private String employeeId;
    @Indexed
    private String referenceNumber;
    private String content;

    public static <T extends MessageContentDocumentAbstract> NotifyMessageDocument create(JsonProvider jsonProvider, String id, String referenceNumber, String employeeId, T data) {
        NotifyMessageDocument document = new NotifyMessageDocument();
        document.setId(id);
        document.setEmployeeId(employeeId);
        document.setContent(jsonProvider.getJson(data));
        document.setReferenceNumber(referenceNumber);
        return document;
    }

    public String getId() {
        return this.id;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getContent() {
        return this.content;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifyMessageDocument)) {
            return false;
        }
        NotifyMessageDocument other = (NotifyMessageDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$employeeId = this.getEmployeeId();
        String other$employeeId = other.getEmployeeId();
        if (this$employeeId == null ? other$employeeId != null : !this$employeeId.equals(other$employeeId)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotifyMessageDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $employeeId = this.getEmployeeId();
        result = result * 59 + ($employeeId == null ? 43 : $employeeId.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "NotifyMessageDocument(id=" + this.getId() + ", employeeId=" + this.getEmployeeId() + ", referenceNumber=" + this.getReferenceNumber() + ", content=" + this.getContent() + ")";
    }
}

