package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.common.QzConstant;
import com.bcxin.backend.domain.signature.service.BeiJingInJTLZSignature;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 京通靓证业务生成请求报文推送ftp，每5分钟检索一次
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJTLZInitTask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;
    private final BeiJingInJTLZSignature beiJingInJTLZSignature;

    public SignatureJTLZInitTask(BeiJingInJTLZSignature beiJingInJTLZSignature) {
        this.beiJingInJTLZSignature = beiJingInJTLZSignature;
    }


    @Override
    protected void runCore() {
        if(QzConstant.QZ_SIGNATURE_SERVER_KEY_BEIJINGIN.equals(serverKey)){
            //北京内网京通靓证报文数据生成.bcx文件上传ftp
            beiJingInJTLZSignature.initJTLZ();
        }
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.jtlz.init";
    }

}
