package com.bcxin.backend.tasks;

import cn.hutool.http.HttpUtil;
import com.bcxin.backend.core.AppConfigProperty;
import org.springframework.stereotype.Component;

/**
 * 流程催办提醒
 */
@Component
public class NoticeOverDueJobTask extends TaskAbstract{

    private final AppConfigProperty appConfigProperty;

    public NoticeOverDueJobTask(AppConfigProperty appConfigProperty) {
        this.appConfigProperty = appConfigProperty;

    }


    @Override
    protected void runCore() throws Exception {
        log("流程催办提醒-开始执行");
        log("流程催办提醒-返回结果："+HttpUtil.get(appConfigProperty.getDomainUrl()+"/api/runtime/job/notifyOverDue"));
        log("流程催办提醒-结束执行");
    }

    @Override
    public String getTaskName() {
        return "overDue.notice";
    }

    public static void main(String[] args) {
        System.out.println(HttpUtil.get("http://localhost:8080/obpm/api/runtime/job/notifyOverDue",3000));
    }
}
