package com.bcxin.backend.jobs;

import com.bcxin.backend.tasks.TaskAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
@ConditionalOnProperty(prefix = "myapps.pushCertificate",name = "enable",havingValue = "true",matchIfMissing = false)
public class SyncCertificateScheduleJob extends ScheduleJobAbstract{
    private final static Logger logger = LoggerFactory.getLogger(SyncCertificateScheduleJob.class);

    /**
     * <b> 北京内网京通靓证废止 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void initSignatureJTLZFZ() {
        //logger.error("执行-北京内网京通靓证废止");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.jtlzfz.init");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * <b> 北京内网京通靓证废止读取ftp外到内.bcx数据文件解析处理结果 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void useSignatureJTLZFZ() {
        //logger.error("执行-北京内网京通靓证废止读取ftp外到内");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.jtlzfz.use");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * <b> 北京内网初始生成京通靓证.bcx数据文件上传ftp </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void initSignatureJTLZ() {
        //logger.error("执行-北京内网初始生成京通靓证.bcx数据文件上传ftp");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.jtlz.init");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * <b> 北京内网初始生成保安服务许可证京通靓证.bcx数据文件输出外网 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Scheduled(fixedDelay = 5 * 60 * 1000)
    public void initSignatureJTLZDocument() {
        //logger.error("执行-北京内网初始生成保安服务许可证京通靓证.bcx数据文件输出外网 ");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.jtlzdocument.init");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * <b> 北京内网读取ftp外到内.bcx数据文件解析处理结果 </b>
     * @author ZXF
     * @create 2024/11/23 0023 15:09
     * @version
     * @注意事项 </b>
     */
    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void useSignatureJTLZ() {
        //logger.error("执行-北京内网读取ftp外到内.bcx数据文件解析处理结果");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.signature.pdf.jtlz.use");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }
}
