package com.bcxin.backend.jobs;

import com.bcxin.backend.certificateSignatures.CertificateSignatureProvider;
import com.bcxin.backend.documentSignatrures.SignatureConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

/**
 * 资格认证签章功能定时任务
 */
@Component
@ConditionalOnProperty(prefix = "myapps.pushCertificate",name = "enable",havingValue = "true",matchIfMissing = false)
public class CertificatePushScheduleJob extends ScheduleJobAbstract {
    private final static Logger logger = LoggerFactory.getLogger(CertificatePushScheduleJob.class);
    private final SignatureConfigProperty signatureConfigProperty;

    public CertificatePushScheduleJob(SignatureConfigProperty signatureConfigProperty) {
        this.signatureConfigProperty = signatureConfigProperty;
    }
}
