package com.bcxin.backend.certificateSignatures.impls;

import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.certificateSignatures.CertificateConfigProperty;
import com.bcxin.backend.certificateSignatures.CertificateSignatureProvider;
import com.bcxin.backend.certificateSignatures.impls.values.SignatureData;
import com.bcxin.backend.certificateSignatures.impls.values.SignaturePdfResult;
import com.bcxin.backend.domain.enums.SxCertDn;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.UUID;

@Component
@Qualifier("shanxi")
public class CertificateSignatureProvider_Shanxi  extends CertificateSignatureProviderAbstract
        implements CertificateSignatureProvider {
    private static final Logger logger = LoggerFactory.getLogger(CertificateSignatureProvider_Shanxi.class);
    private static final String BASE64_PREFIX = "data:image/png;base64,";

    public CertificateSignatureProvider_Shanxi(CertificateConfigProperty configProperty,
                                               SignatureQueuesRepository signatureQueuesRepository,
                                               @Qualifier("primaryJdbcTemplate") JdbcTemplate jdbcTemplate,
                                               ConvertServiceImpl convertService) {
        super(configProperty, signatureQueuesRepository, jdbcTemplate, convertService);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected SignaturePdfResult generateSignaturePdf(SignatureQueuesDTO queue) throws IOException {
        SignatureData data = JSONObject.parseObject(queue.getData(), SignatureData.class);
        SxCertDn sxCertDn = SxCertDn.getByAreaName(data.getCertificatefrom());
        String traceId = UUID.randomUUID().toString();

        logger.error("{}====> 电子签章（无章PDF生成）定时任务开始：accept.sxCertDn:{}", traceId, sxCertDn);
        if (sxCertDn == null || StringUtils.isEmpty(sxCertDn.getSealId())) {
            useSql(queue.getId(), queue.getBusiness_id(), "证书所属区域无有效电子印章");
            return SignaturePdfResult.createIgnoreResult();
        }

        String tempPDF = configProperty.getTempPDF();
        logger.error("{}====> 电子签章（无章PDF生成）定时任务开始：accept.sxCertDn.SealId:{}", traceId, sxCertDn.getSealId());
        //先将文件命名为.temp
        data.setUnSignaturePDF(tempPDF + "/" + System.currentTimeMillis() + sxCertDn.toString() + "queueId_" + queue.getId() + ".temp");
        String toDay = data.getFzDate();
        if (StringUtils.isEmpty(toDay)) {
            toDay = DateUtil.today();
        }
        logger.error("{}-====> 电子签章（无章PDF生成）定时任务开始：accept.toDay:{}", traceId, toDay);
        data.setZYear(toDay.split("-")[0]);
        data.setZMonth(toDay.split("-")[1]);
        data.setZDay(toDay.split("-")[2]);
        try {
            byte[] imageBytes = HttpUtil.downloadBytes(data.getHeadphoto());
            String base64Str = Base64Encoder.encode(imageBytes);
            data.setHeadphoto(BASE64_PREFIX + base64Str);
        } catch (Exception e) {
            useSql(queue.getId(), queue.getBusiness_id(), "头像信息参数异常:" + e.getMessage());
            return SignaturePdfResult.createIgnoreResult();
        }

        String result = "";
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(queue.getTemplate_url());
        sharedConvertDto.setFormData(data);
        try {
            //最终输出为.pdf文件，主要是为了避免pdf 0kb时就被剪切走
            result = convertService.execConvertHtmltopdfForTemp(sharedConvertDto);
        } catch (IOException e) {
            result = "";
            logger.error("{}====> 电子签章定时任务开始.createPDF.accept.pdf生成异常", e);
        }

        logger.error("====> 电子签章（无章PDF生成）定时任务开始：accept.result:{}", result);

        return SignaturePdfResult.create(result, "");
    }

    private void useSql(String id, String business_id, String errMsg) {
        String sql = "DELETE FROM obpm2_security.signature_queues s WHERE s.id=" + id + ";";
        //失败
        jdbcTemplate.update(sql);
        String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"3\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"" + errMsg + "\" WHERE ID=\"" + business_id + "\";";
        jdbcTemplate.update(updateSql);
        logger.info("====> 电子签章定时任务开始.createPDF.accept.单次业务{},end", errMsg);
    }
}
