package com.bcxin.backend.scheduling;

import com.bcxin.backend.service.SignatureService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * <b> 签章定时任务 </b>
 * @author ZXF
 * @create 2024/11/20 0020 16:18
 * @version
 * @注意事项 </b>
 */
@Slf4j
@Component
public class SignatureTask {

    @Autowired
    private SignatureService signatureService;

    @Scheduled(cron = "${myapps.signature.scheduled.documenttiming}")
    public void documenttiming() {
        log.info("===================================文书签章定时任务===================================");
        signatureService.documentSignature();
        log.info("===================================文书签章定时任务结束===================================");
    }
    /*@Scheduled(cron = "${myapps.signature.scheduled.bazgztiming}")
    public void bazgztiming() {
        log.info("===================================保安资格证签章定时任务===================================");
        signatureService.bazgzSignature();
        log.info("===================================保安资格证签章定时任务结束===================================");
    }*/
    /*@Scheduled(cron = "${myapps.signature.scheduled.jttiming}")
    public void jttiming() {
        log.info("===================================京通同步定时任务===================================");
        signatureService.syncJT();
        log.info("===================================京通同步定时任务结束===================================");
    }*/

}
