/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RdProjectDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdProjectDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RdProjectEntity;
import java.text.SimpleDateFormat;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdProjectEntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(RdProjectEntityUtils.class);

    public static RdProjectDocument toDocument(RdProjectEntity ii, RdProjectDocumentRepository projectDocumentRepository) {
        try {
            RdProjectDocument document = null;
            Optional projectDocumentOptional = projectDocumentRepository.findById((Object)ii.getId());
            if (projectDocumentOptional.isPresent()) {
                document = (RdProjectDocument)projectDocumentOptional.get();
            }
            if (document == null) {
                document = new RdProjectDocument();
                document.setId(ii.getId());
            }
            document.rest();
            document.setName(ii.getName());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (ii.getBeginDate() != null) {
                document.setBeginDate(dateFormat.format(ii.getBeginDate()));
            } else {
                document.setBeginDate(null);
            }
            document.setEndDate(null);
            if (ii.getBeginDate() != null) {
                document.setEndDate(dateFormat.format(ii.getEndDate()));
            }
            document.setOrganizationId(ii.getOrganizationId());
            document.setPrincipalId(ii.getPrincipalId());
            document.setState(ii.getState());
            document.updateWord(new String[]{ii.getName(), ii.getAddress()});
            return document;
        }
        catch (Exception ex) {
            logger.error("\u9879\u76ee\u5236\u5ea6-\u89e3\u6790\u6570\u636e\u53d1\u751f\u5f02\u5e38:id={};name={};", new Object[]{ii.getId(), ii.getName(), ex});
            return null;
        }
    }
}

